/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.store;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J!\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\n\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Ldev/numbits/healtimer/store/CooldownStore;", "", "<init>", "()V", "", "clearAll", "Ljava/util/UUID;", "id", "", "forceRestart", "startCooldown", "(Ljava/util/UUID;Z)V", "Lnet/minecraft/class_1657;", "player", "(Lnet/minecraft/class_1657;Z)V", "", "getRemainingCooldownMillis", "(Ljava/util/UUID;)J", "(Lnet/minecraft/class_1657;)J", "", "getLastHealth", "(Ljava/util/UUID;)F", "health", "setLastHealth", "(Ljava/util/UUID;F)V", "", "cooldowns", "Ljava/util/Map;", "lastHealths", "getCooldownNanos", "()J", "cooldownNanos", "HealTimer"})
public final class CooldownStore {
    @NotNull
    public static final CooldownStore INSTANCE = new CooldownStore();
    @NotNull
    private static final Map<UUID, Long> cooldowns = new ConcurrentHashMap();
    @NotNull
    private static final Map<UUID, Float> lastHealths = new ConcurrentHashMap();

    private CooldownStore() {
    }

    private final long getCooldownNanos() {
        return Math.max(1L, 60L) * 1000000000L;
    }

    public final void clearAll() {
        cooldowns.clear();
        lastHealths.clear();
    }

    @JvmOverloads
    public final void startCooldown(@NotNull UUID id, boolean forceRestart) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        long now = System.nanoTime();
        if (forceRestart) {
            cooldowns.put(id, now);
        } else {
            cooldowns.putIfAbsent(id, now);
        }
    }

    public static /* synthetic */ void startCooldown$default(CooldownStore cooldownStore, UUID uUID, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cooldownStore.startCooldown(uUID, bl);
    }

    @JvmOverloads
    public final void startCooldown(@NotNull class_1657 player, boolean forceRestart) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        this.startCooldown(uUID, forceRestart);
    }

    public static /* synthetic */ void startCooldown$default(CooldownStore cooldownStore, class_1657 class_16572, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cooldownStore.startCooldown(class_16572, bl);
    }

    public final long getRemainingCooldownMillis(@NotNull UUID id) {
        long l;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Long l2 = cooldowns.get(id);
        if (l2 == null) {
            return 0L;
        }
        long start = l2;
        long elapsed = System.nanoTime() - start;
        long remaining = this.getCooldownNanos() - elapsed;
        if (remaining <= 0L) {
            cooldowns.remove(id);
            l = 0L;
        } else {
            l = remaining / 1000000L;
        }
        return l;
    }

    public final long getRemainingCooldownMillis(@NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        return this.getRemainingCooldownMillis(uUID);
    }

    public final float getLastHealth(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Float f = lastHealths.get(id);
        return f != null ? f.floatValue() : -1.0f;
    }

    public final void setLastHealth(@NotNull UUID id, float health) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        lastHealths.put(id, Float.valueOf(health));
    }

    @JvmOverloads
    public final void startCooldown(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CooldownStore.startCooldown$default(this, id, false, 2, null);
    }

    @JvmOverloads
    public final void startCooldown(@NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CooldownStore.startCooldown$default(this, player, false, 2, null);
    }
}

