/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.trackers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00190\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ldev/numbits/healtimer/trackers/PinkSurfaceTracker;", "", "<init>", "()V", "Lnet/minecraft/class_310;", "mc", "", "tick", "(Lnet/minecraft/class_310;)V", "Ljava/util/UUID;", "id", "", "windowMs", "", "wasRecentlyOnPink", "(Ljava/util/UUID;I)Z", "Lnet/minecraft/class_1657;", "player", "isOnPink", "(Lnet/minecraft/class_310;Lnet/minecraft/class_1657;)Z", "Lnet/minecraft/class_2248;", "block", "isPink", "(Lnet/minecraft/class_2248;)Z", "", "", "lastOnPinkMs", "Ljava/util/Map;", "HealTimer"})
public final class PinkSurfaceTracker {
    @NotNull
    public static final PinkSurfaceTracker INSTANCE = new PinkSurfaceTracker();
    @NotNull
    private static final Map<UUID, Long> lastOnPinkMs = new ConcurrentHashMap();

    private PinkSurfaceTracker() {
    }

    @JvmStatic
    public static final void tick(@Nullable class_310 mc) {
        class_310 class_3102 = mc;
        if (class_3102 == null || (class_3102 = class_3102.field_1687) == null) {
            return;
        }
        class_310 world = class_3102;
        for (class_742 player : world.method_18456()) {
            Intrinsics.checkNotNull((Object)player);
            if (!INSTANCE.isOnPink(mc, (class_1657)player)) continue;
            lastOnPinkMs.put(player.method_5667(), System.currentTimeMillis());
        }
    }

    @JvmStatic
    public static final boolean wasRecentlyOnPink(@NotNull UUID id, int windowMs) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Long l = lastOnPinkMs.get(id);
        if (l == null) {
            return false;
        }
        long t = l;
        int window = Math.max(0, windowMs);
        return System.currentTimeMillis() - t <= (long)window;
    }

    private final boolean isOnPink(class_310 mc, class_1657 player) {
        class_638 class_6382 = mc.field_1687;
        if (class_6382 == null) {
            return false;
        }
        class_638 world = class_6382;
        class_2338 class_23382 = player.method_24515();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
        class_2338 feet = class_23382;
        class_2338 class_23383 = feet.method_10074();
        Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"down(...)");
        class_2338 under = class_23383;
        class_2248 class_22482 = world.method_8320(feet).method_26204();
        Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"getBlock(...)");
        if (this.isPink(class_22482)) {
            return true;
        }
        class_2248 class_22483 = world.method_8320(under).method_26204();
        Intrinsics.checkNotNullExpressionValue((Object)class_22483, (String)"getBlock(...)");
        if (this.isPink(class_22483)) {
            return true;
        }
        class_238 class_2382 = player.method_5829().method_989(0.0, -0.05, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)class_2382, (String)"offset(...)");
        class_238 box = class_2382;
        class_243[] class_243Array = new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1322, box.field_1324)};
        for (class_243 c : class_243Array) {
            class_2338 pos = class_2338.method_49638((class_2374)((class_2374)c));
            class_2248 class_22484 = world.method_8320(pos).method_26204();
            Intrinsics.checkNotNullExpressionValue((Object)class_22484, (String)"getBlock(...)");
            if (this.isPink(class_22484)) {
                return true;
            }
            class_2248 class_22485 = world.method_8320(pos.method_10074()).method_26204();
            Intrinsics.checkNotNullExpressionValue((Object)class_22485, (String)"getBlock(...)");
            if (!this.isPink(class_22485)) continue;
            return true;
        }
        return false;
    }

    private final boolean isPink(class_2248 block) {
        return Intrinsics.areEqual((Object)block, (Object)class_2246.field_10434);
    }
}

