/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.mixin;

import dev.numbits.healtimer.config.ModConfig;
import dev.numbits.healtimer.states.EnabledState;
import dev.numbits.healtimer.states.FrameState;
import dev.numbits.healtimer.storage.CooldownStore;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class MixinPlayerEntity {
    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    private void appendTimerLunar(CallbackInfoReturnable<class_2561> cir) {
        if (!FabricLoader.getInstance().isModLoaded("ichor")) {
            return;
        }
        class_2561 original = (class_2561)cir.getReturnValue();
        class_2561 modified = this.appendHealTimer(original);
        cir.setReturnValue((Object)modified);
    }

    @Unique
    private class_2561 appendHealTimer(class_2561 inText) {
        if (!EnabledState.get() || !((Boolean)ModConfig.enabled.get()).booleanValue()) {
            return inText;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || mc.field_1724 == null) {
            return inText;
        }
        class_1657 self = (class_1657)this;
        UUID id = self.method_5667();
        if (!((Boolean)ModConfig.showSelfNametag.get()).booleanValue() && id.equals(mc.field_1724.method_5667())) {
            return inText;
        }
        long ms = CooldownStore.getRemainingCooldownMillis(id);
        FrameState.mark(id);
        class_5250 out = inText.method_27661().method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080));
        if (ms > 0L) {
            boolean useFloat = (Boolean)ModConfig.useFloatSeconds.get();
            float secondsFloat = (float)ms / 1000.0f;
            long secondsInt = (ms + 999L) / 1000L;
            String secondsText = useFloat ? String.format(Locale.US, "%.1f", Float.valueOf(secondsFloat)) : String.valueOf(secondsInt);
            float secondsForLerp = useFloat ? secondsFloat : (float)secondsInt;
            float total = Math.max(1.0f, 60.0f);
            int rgb = this.lerpRGB(16202044, 3405724, secondsForLerp, total);
            out.method_10852((class_2561)class_2561.method_43470((String)secondsText).method_27694(s -> s.method_27703(class_5251.method_27717((int)rgb))));
        } else {
            out.method_10852((class_2561)class_2561.method_43470((String)"\u2714").method_27694(s -> s.method_27703(class_5251.method_27717((int)3405724))));
        }
        return out;
    }

    @Unique
    private int lerpRGB(int start, int end, float value, float max) {
        float t = max <= 0.0f ? 1.0f : class_3532.method_15363((float)(value / max), (float)0.0f, (float)1.0f);
        int sr = start >> 16 & 0xFF;
        int sg = start >> 8 & 0xFF;
        int sb = start & 0xFF;
        int er = end >> 16 & 0xFF;
        int eg = end >> 8 & 0xFF;
        int eb = end & 0xFF;
        int r = (int)((float)sr + (float)(er - sr) * t);
        int g = (int)((float)sg + (float)(eg - sg) * t);
        int b = (int)((float)sb + (float)(eb - sb) * t);
        return r << 16 | g << 8 | b;
    }
}

