/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.mixin;

import dev.numbits.healtimer.config.ModConfig;
import dev.numbits.healtimer.states.ServerState;
import dev.numbits.healtimer.storage.CooldownStore;
import dev.numbits.healtimer.trackers.BelowNameTracker;
import dev.numbits.healtimer.trackers.PinkSurfaceTracker;
import java.util.UUID;
import net.minecraft.class_2736;
import net.minecraft.class_2757;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class MixinScoreboard {
    @Unique
    private static final int SLOT_BELOW_NAME = 2;

    @Inject(method={"onScoreboardDisplay"}, at={@At(value="TAIL")})
    private void healtimer$onDisplay(class_2736 packet, CallbackInfo ci) {
        if (!((Boolean)ModConfig.enabled.get()).booleanValue()) {
            return;
        }
        if (packet.method_11806() != 2) {
            return;
        }
        String name = packet.method_11804();
        if (name == null || name.isEmpty()) {
            return;
        }
        BelowNameTracker.setBelowNameObjective(name);
    }

    @Inject(method={"onScoreboardPlayerUpdate"}, at={@At(value="TAIL")})
    private void healtimer$onScoreboardPlayerUpdate(class_2757 packet, CallbackInfo ci) {
        if (!((Boolean)ModConfig.enabled.get()).booleanValue()) {
            return;
        }
        if (ServerState.isCraftm()) {
            this.handleCraftm(packet);
        } else if (ServerState.isRtsv()) {
            this.handleRtsv(packet);
        }
    }

    @Unique
    private void handleCraftm(class_2757 packet) {
        float healed;
        String below = BelowNameTracker.getBelowNameObjective();
        if (below.isEmpty() || !below.equals(packet.method_11864())) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1562() == null) {
            return;
        }
        UUID id = this.resolvePlayerId(mc, packet.method_11862());
        if (id == null) {
            return;
        }
        if (PinkSurfaceTracker.wasRecentlyOnPink(id, 150)) {
            CooldownStore.setLastHealth(id, packet.method_11865());
            return;
        }
        float cur = packet.method_11865();
        float last = CooldownStore.getLastHealth(id);
        long remain = CooldownStore.getRemainingCooldownMillis(id);
        if (last >= 0.0f && (healed = cur - last) >= 15.0f && remain <= 0L) {
            CooldownStore.startCooldown(id);
        }
        CooldownStore.setLastHealth(id, cur);
    }

    @Unique
    private void handleRtsv(class_2757 packet) {
    }

    @Unique
    private UUID resolvePlayerId(class_310 mc, String entry) {
        if (entry == null || entry.isEmpty()) {
            return null;
        }
        class_634 handler = mc.method_1562();
        if (handler == null) {
            return null;
        }
        class_640 ple = handler.method_2874(entry);
        if (ple == null) {
            try {
                ple = handler.method_2871(UUID.fromString(entry));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (ple == null || ple.method_2966() == null) {
            return null;
        }
        return ple.method_2966().getId();
    }
}

