/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.storage;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;

public final class CooldownStore {
    private static final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Float> lastHealths = new ConcurrentHashMap<UUID, Float>();

    private CooldownStore() {
    }

    private static long getCooldownNanos() {
        return Math.max(1L, 60L) * 1000000000L;
    }

    public static void clearAll() {
        cooldowns.clear();
        lastHealths.clear();
    }

    public static void startCooldown(UUID id) {
        CooldownStore.startCooldown(id, false);
    }

    public static void startCooldown(UUID id, boolean forceRestart) {
        long now = System.nanoTime();
        if (forceRestart) {
            cooldowns.put(id, now);
        } else {
            cooldowns.putIfAbsent(id, now);
        }
    }

    public static void startCooldown(class_1657 player) {
        CooldownStore.startCooldown(player, false);
    }

    public static void startCooldown(class_1657 player, boolean forceRestart) {
        CooldownStore.startCooldown(player.method_5667(), forceRestart);
    }

    public static long getRemainingCooldownMillis(UUID id) {
        Long start = cooldowns.get(id);
        if (start == null) {
            return 0L;
        }
        long elapsed = System.nanoTime() - start;
        long remaining = CooldownStore.getCooldownNanos() - elapsed;
        if (remaining <= 0L) {
            cooldowns.remove(id);
            return 0L;
        }
        return remaining / 1000000L;
    }

    public static long getRemainingCooldownMillis(class_1657 player) {
        return CooldownStore.getRemainingCooldownMillis(player.method_5667());
    }

    public static float getLastHealth(UUID id) {
        Float value = lastHealths.get(id);
        return value != null ? value.floatValue() : -1.0f;
    }

    public static void setLastHealth(UUID id, float health) {
        lastHealths.put(id, Float.valueOf(health));
    }
}

