/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.mixin;

import dev.numbits.healtimer.config.ModConfig;
import dev.numbits.healtimer.states.EnabledState;
import dev.numbits.healtimer.utils.CooldownStore;
import dev.numbits.healtimer.utils.LabelContext;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_897.class})
public class HealCooldownNametagMixin {
    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/EntityRenderer;renderLabelIfPresent(Lnet/minecraft/entity/Entity;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"))
    private void modifyLabelArgs(Args args) {
        if (!EnabledState.get() || !ModConfig.enabled) {
            return;
        }
        class_1297 entity = (class_1297)args.get(0);
        if (!(entity instanceof class_1657)) {
            return;
        }
        LabelContext.setCurrentForRender((class_1297)entity, (boolean)true);
        class_310 mc = class_310.method_1551();
        if (!ModConfig.showSelfNametag && mc.field_1724 != null && mc.field_1724.equals((Object)entity)) {
            return;
        }
        CooldownStore.Entry cooldownEntry = CooldownStore.get(entity);
        long remainingSeconds = 0L;
        int maxSeconds = ModConfig.cooldown;
        if (cooldownEntry != null && "COMMAND".equals(cooldownEntry.healType())) {
            long timeSincePacket = System.currentTimeMillis() - cooldownEntry.timestampMillis();
            long totalRemainingMs = (long)cooldownEntry.remainingSeconds() * 1000L - timeSincePacket;
            remainingSeconds = Math.max(0L, (totalRemainingMs + 999L) / 1000L);
            maxSeconds = cooldownEntry.maxSeconds();
        }
        int checkColor = ModConfig.checkColor & 0xFFFFFF;
        int startRGB = ModConfig.startColor & 0xFFFFFF;
        int endRGB = ModConfig.endColor & 0xFFFFFF;
        class_5250 out = ((class_2561)args.get(1)).method_27661().method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080));
        if (remainingSeconds > 0L) {
            int total = Math.max(1, maxSeconds);
            int rgb = HealCooldownNametagMixin.lerpRGB(startRGB, endRGB, remainingSeconds, total);
            out.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(remainingSeconds)).method_27694(s -> s.method_27703(class_5251.method_27717((int)rgb))));
        } else {
            out.method_10852((class_2561)class_2561.method_43470((String)"\u2714").method_27694(s -> s.method_27703(class_5251.method_27717((int)checkColor))));
        }
        args.set(1, (Object)out);
    }

    private static int lerpRGB(int startRGB, int endRGB, long sec, int total) {
        float t = 1.0f - Math.min(1.0f, Math.max(0.0f, (float)sec / (float)total));
        int r1 = startRGB >> 16 & 0xFF;
        int g1 = startRGB >> 8 & 0xFF;
        int b1 = startRGB & 0xFF;
        int r2 = endRGB >> 16 & 0xFF;
        int g2 = endRGB >> 8 & 0xFF;
        int b2 = endRGB & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

