/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.tracker;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public final class PinkSurfaceTracker {
    private static final Map<UUID, Long> lastOnPinkMs = new ConcurrentHashMap<UUID, Long>();

    private PinkSurfaceTracker() {
    }

    public static void tick(class_310 mc) {
        if (mc == null || mc.field_1687 == null) {
            return;
        }
        for (class_1657 p : mc.field_1687.method_18456()) {
            if (!PinkSurfaceTracker.isOnPink(mc, p)) continue;
            lastOnPinkMs.put(p.method_5667(), System.currentTimeMillis());
        }
    }

    public static boolean wasRecentlyOnPink(UUID id, int windowMs) {
        Long t = lastOnPinkMs.get(id);
        if (t == null) {
            return false;
        }
        return System.currentTimeMillis() - t <= (long)Math.max(0, windowMs);
    }

    private static boolean isOnPink(class_310 mc, class_1657 p) {
        class_243[] corners;
        class_638 world = mc.field_1687;
        if (world == null) {
            return false;
        }
        class_2338 feet = p.method_24515();
        class_2338 under = feet.method_10074();
        if (PinkSurfaceTracker.isPink(world.method_8320(feet).method_26204())) {
            return true;
        }
        if (PinkSurfaceTracker.isPink(world.method_8320(under).method_26204())) {
            return true;
        }
        class_238 box = p.method_5829().method_989(0.0, -0.05, 0.0);
        for (class_243 c : corners = new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1322, box.field_1324)}) {
            class_2338 pos = class_2338.method_49638((class_2374)c);
            if (PinkSurfaceTracker.isPink(world.method_8320(pos).method_26204())) {
                return true;
            }
            if (!PinkSurfaceTracker.isPink(world.method_8320(pos.method_10074()).method_26204())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPink(class_2248 b) {
        return b == class_2246.field_10434;
    }
}

