/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.utils;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_2540;

public class CooldownStore {
    private static final ConcurrentHashMap<class_1297, Entry> MAP = new ConcurrentHashMap();

    public static void update(class_1297 entity, String healType, int remainingSeconds, int maxSeconds) {
        if (entity == null) {
            return;
        }
        MAP.put(entity, new Entry(entity.method_5667().toString(), healType, remainingSeconds, maxSeconds, System.currentTimeMillis()));
    }

    public static Entry get(class_1297 entity) {
        return MAP.get(entity);
    }

    public static Entry readFromPacket(class_2540 buf) {
        int version = buf.readInt();
        String playerUUID = buf.method_19772();
        String healType = buf.method_19772();
        int remainingCooldown = buf.readInt();
        int maxCooldown = buf.readInt();
        long timestampMillis = buf.readLong();
        return new Entry(playerUUID, healType, remainingCooldown, maxCooldown, timestampMillis);
    }

    public static void clear() {
        MAP.clear();
    }

    public static class Entry {
        private final String playerUUID;
        private final String healType;
        private final int remainingSeconds;
        private final int maxSeconds;
        private final long timestampMillis;

        public Entry(String playerUUID, String healType, int remainingSeconds, int maxSeconds, long timestampMillis) {
            this.playerUUID = playerUUID;
            this.healType = healType;
            this.remainingSeconds = remainingSeconds;
            this.maxSeconds = maxSeconds;
            this.timestampMillis = timestampMillis;
        }

        public String playerUUID() {
            return this.playerUUID;
        }

        public String healType() {
            return this.healType;
        }

        public int remainingSeconds() {
            return this.remainingSeconds;
        }

        public int maxSeconds() {
            return this.maxSeconds;
        }

        public long timestampMillis() {
            return this.timestampMillis;
        }
    }
}

