/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.data.DRGeneratorNetwork;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.util.CollectorConfig;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EnergyCollectorTileEntity
extends TickingTileEntity {
    public static final float CRYSTAL_MIN_POWER = 1.0E-5f;
    public static final int MAXTICKS = 20;
    private Set<BlockPos> crystals = new HashSet<BlockPos>();
    private boolean lasersActive = false;
    private int laserStartup = 0;
    private int radiationUpdateCount = 20;
    private int blobId = -1;
    private static final int ERROR_TOOMANYCRYSTALS = -1;
    private static final int ERROR_TOOMUCHPOWER = -2;

    public EnergyCollectorTileEntity(BlockPos pos, BlockState state) {
        super(GeneratorModule.TYPE_ENERGY_COLLECTOR.get(), pos, state);
    }

    public void tickServer() {
        boolean active = false;
        int startup = 0;
        GeneratorBlob network = null;
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (te instanceof GeneratorPartTileEntity) {
            GeneratorPartTileEntity generator = (GeneratorPartTileEntity)te;
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.f_58857_);
            if (this.blobId != generator.getMultiblockId()) {
                if (this.blobId != -1) {
                    this.getDriver().modify(this.blobId, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
                }
                this.blobId = generator.getMultiblockId();
                this.getDriver().modify(this.blobId, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
                generatorNetwork.save();
            }
            int multiblockId = generator.getMultiblockId();
            network = generator.getBlob();
            if (network != null) {
                if (network.isActive()) {
                    this.getDriver().modify(multiblockId, holder -> {
                        int rfPerTick = this.calculateRF();
                        ((GeneratorBlob)holder.getMb()).setLastRfPerTick(rfPerTick);
                        int newEnergy = ((GeneratorBlob)holder.getMb()).getEnergy() + rfPerTick;
                        int maxEnergy = ((GeneratorBlob)holder.getMb()).getGeneratorBlocks() * (Integer)GeneratorConfig.POWER_STORAGE_PER_BLOCK.get();
                        if (newEnergy > maxEnergy) {
                            newEnergy = maxEnergy;
                        }
                        if (((GeneratorBlob)holder.getMb()).getEnergy() != newEnergy) {
                            ((GeneratorBlob)holder.getMb()).setEnergy(newEnergy);
                            generatorNetwork.save();
                        }
                    });
                    active = true;
                } else {
                    this.getDriver().modify(multiblockId, holder -> ((GeneratorBlob)holder.getMb()).setLastRfPerTick(0));
                }
                startup = network.getStartupCounter();
            }
        } else if (this.blobId != -1) {
            this.blobId = -1;
            this.m_6596_();
        }
        if (active != this.lasersActive || startup != this.laserStartup) {
            boolean doFind = this.lasersActive != active || this.laserStartup > (Integer)GeneratorConfig.STARTUP_TIME.get() - 5;
            this.lasersActive = active;
            this.laserStartup = startup;
            this.markDirtyClient();
            if (doFind && te instanceof GeneratorPartTileEntity) {
                this.findCrystals(network);
            }
        }
    }

    public void disableCrystalGlow() {
        for (BlockPos coordinate : this.crystals) {
            BlockEntity te = this.f_58857_.m_7702_(new BlockPos(this.m_58899_().m_123341_() + coordinate.m_123341_(), this.m_58899_().m_123342_() + coordinate.m_123342_(), this.m_58899_().m_123343_() + coordinate.m_123343_()));
            if (!(te instanceof ResonatingCrystalTileEntity)) continue;
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            crystal.setGlowing(false);
        }
    }

    public int getLaserStartup() {
        return this.laserStartup;
    }

    public boolean areLasersActive() {
        return this.lasersActive;
    }

    private MultiblockDriver<GeneratorBlob> getDriver() {
        return DRGeneratorNetwork.getNetwork(this.f_58857_).getDriver();
    }

    private int calculateRF() {
        HashSet<BlockPos> tokeep = new HashSet<BlockPos>();
        boolean dirty = false;
        float radiationRadius = 0.0f;
        float radiationStrength = 0.0f;
        boolean doRadiation = false;
        --this.radiationUpdateCount;
        if (this.radiationUpdateCount <= 0) {
            this.radiationUpdateCount = 20;
            doRadiation = true;
        }
        int rf = 0;
        for (BlockPos coordinate : this.crystals) {
            BlockEntity te = this.m_58904_().m_7702_(new BlockPos(this.m_58899_().m_123341_() + coordinate.m_123341_(), this.m_58899_().m_123342_() + coordinate.m_123342_(), this.m_58899_().m_123343_() + coordinate.m_123343_()));
            if (te instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
                if (crystal.getPower() > (double)1.0E-5f) {
                    crystal.setGlowing(this.lasersActive);
                    tokeep.add(coordinate);
                    double power = crystal.getPower();
                    if (power < (double)crystal.getPowerPerTick()) {
                        crystal.setPower(0.0);
                        continue;
                    }
                    crystal.setPower(power -= (double)crystal.getPowerPerTick());
                    int rfPerTick = crystal.getRfPerTick();
                    rf += rfPerTick;
                    if (!doRadiation) continue;
                    double purity = crystal.getPurity();
                    float radius = DRRadiationManager.calculateRadiationRadius(crystal.getStrength(), crystal.getEfficiency(), purity);
                    if (radius > radiationRadius) {
                        radiationRadius = radius;
                    }
                    float strength = DRRadiationManager.calculateRadiationStrength(crystal.getStrength(), purity);
                    radiationStrength += strength;
                    continue;
                }
                crystal.setGlowing(false);
                dirty = true;
                continue;
            }
            dirty = true;
        }
        if (dirty) {
            this.crystals = tokeep;
            this.markDirtyClient();
        }
        if (doRadiation && radiationRadius > 0.1f) {
            GlobalPos thisCoordinate;
            DRRadiationManager radiationManager = DRRadiationManager.getManager(this.m_58904_());
            if (radiationManager.getRadiationSource(thisCoordinate = GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.m_58899_())) == null) {
                Logging.log((String)("Created radiation source with radius " + radiationRadius + " and strength " + radiationStrength));
            }
            DRRadiationManager.RadiationSource radiationSource = radiationManager.getOrCreateRadiationSource(thisCoordinate);
            radiationSource.update(radiationRadius, radiationStrength, 20);
            radiationManager.save();
        }
        return rf;
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        if (!world.m_5776_() && (te = world.m_7702_(pos.m_7495_())) instanceof GeneratorPartTileEntity) {
            this.blobId = ((GeneratorPartTileEntity)te).getMultiblockId();
            this.getDriver().modify(this.blobId, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
        }
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        BlockEntity te = world.m_7702_(pos.m_7495_());
        if (te instanceof GeneratorPartTileEntity) {
            int id = ((GeneratorPartTileEntity)te).getMultiblockId();
            this.getDriver().modify(id, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
        }
    }

    private void findCrystals(GeneratorBlob network) {
        HashSet<BlockPos> newCrystals = new HashSet<BlockPos>();
        int maxSupportedRF = network.getGeneratorBlocks() * (Integer)GeneratorConfig.MAX_POWER_INPUT_PER_BLOCK.get();
        boolean tooManyCrystals = false;
        boolean tooMuchPower = false;
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        for (int y = yCoord - (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); y <= yCoord + (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); ++y) {
            if (y < this.f_58857_.m_141937_() || y >= this.f_58857_.m_151558_()) continue;
            int maxhordist = (Integer)CollectorConfig.MAX_HORIZONTAL_CRYSTAL_DISTANCE.get();
            for (int x = xCoord - maxhordist; x <= xCoord + maxhordist; ++x) {
                for (int z = zCoord - maxhordist; z <= zCoord + maxhordist; ++z) {
                    if (!(this.f_58857_.m_8055_(new BlockPos(x, y, z)).m_60734_() instanceof ResonatingCrystalBlock)) continue;
                    if ((maxSupportedRF = this.addCrystal(x, y, z, network, newCrystals, this.crystals, maxSupportedRF)) == -1) {
                        tooManyCrystals = true;
                        continue;
                    }
                    if (maxSupportedRF != -2) continue;
                    tooMuchPower = true;
                }
            }
        }
        if (!newCrystals.equals(this.crystals)) {
            this.crystals = newCrystals;
            this.m_6596_();
        }
        if (this.lasersActive && (tooManyCrystals || tooMuchPower)) {
            if (tooManyCrystals) {
                Broadcaster.broadcast((Level)this.m_58904_(), (int)xCoord, (int)yCoord, (int)zCoord, (String)"There are too many crystals for this size generator!", (float)100.0f);
            }
            if (tooMuchPower) {
                Broadcaster.broadcast((Level)this.m_58904_(), (int)xCoord, (int)yCoord, (int)zCoord, (String)"Some crystals are too powerful for this size generator!!", (float)100.0f);
            }
        }
    }

    public void addCrystal(int x, int y, int z) {
        if (this.blobId == -1) {
            return;
        }
        DRGeneratorNetwork channels = DRGeneratorNetwork.getNetwork(this.f_58857_);
        GeneratorBlob blob = channels.getBlob(this.blobId);
        if (blob == null) {
            return;
        }
        int maxSupportedRF = blob.getGeneratorBlocks() * (Integer)GeneratorConfig.MAX_POWER_INPUT_PER_BLOCK.get();
        for (BlockPos coordinate : this.crystals) {
            ResonatingCrystalTileEntity crystal;
            BlockEntity te = this.f_58857_.m_7702_(new BlockPos(this.m_58899_().m_123341_() + coordinate.m_123341_(), this.m_58899_().m_123342_() + coordinate.m_123342_(), this.m_58899_().m_123343_() + coordinate.m_123343_()));
            if (!(te instanceof ResonatingCrystalTileEntity) || !((crystal = (ResonatingCrystalTileEntity)te).getPower() > (double)1.0E-5f)) continue;
            maxSupportedRF -= crystal.getRfPerTick();
        }
        if (this.addCrystal(x, y, z, blob, this.crystals, this.crystals, maxSupportedRF) >= 0) {
            this.m_6596_();
        }
    }

    private int addCrystal(int x, int y, int z, GeneratorBlob network, Set<BlockPos> newCrystals, Set<BlockPos> oldCrystals, int maxSupportedRF) {
        int maxSupportedCrystals = network.getGeneratorBlocks() * (Integer)GeneratorConfig.MAX_CRYSTALS_PER_BLOCK.get();
        BlockEntity te = this.f_58857_.m_7702_(new BlockPos(x, y, z));
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            if (crystal.getPower() > (double)1.0E-5f) {
                BlockPos crystalCoordinate = new BlockPos(x - this.m_58899_().m_123341_(), y - this.m_58899_().m_123342_(), z - this.m_58899_().m_123343_());
                if (crystal.isGlowing() && !oldCrystals.contains(crystalCoordinate)) {
                    return maxSupportedRF;
                }
                if (newCrystals.size() >= maxSupportedCrystals) {
                    crystal.setGlowing(false);
                    return -1;
                }
                if (crystal.getRfPerTick() > maxSupportedRF) {
                    crystal.setGlowing(false);
                    return -2;
                }
                maxSupportedRF -= crystal.getRfPerTick();
                newCrystals.add(crystalCoordinate);
                crystal.setGlowing(this.lasersActive);
            } else {
                crystal.setGlowing(false);
            }
        }
        return maxSupportedRF;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        this.saveClientDataToNBT(tagCompound);
        tagCompound.m_128405_("networkId", this.blobId);
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.loadClientDataFromNBT(tagCompound);
        this.blobId = tagCompound.m_128441_("networkId") ? tagCompound.m_128451_("networkId") : -1;
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.lasersActive = tagCompound.m_128471_("lasersActive");
        this.laserStartup = tagCompound.m_128451_("laserStartup");
        byte[] crystalX = tagCompound.m_128463_("crystalsX");
        byte[] crystalY = tagCompound.m_128463_("crystalsY");
        byte[] crystalZ = tagCompound.m_128463_("crystalsZ");
        this.crystals.clear();
        for (int i = 0; i < crystalX.length; ++i) {
            this.crystals.add(new BlockPos((int)crystalX[i], (int)crystalY[i], (int)crystalZ[i]));
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        byte[] crystalX = new byte[this.crystals.size()];
        byte[] crystalY = new byte[this.crystals.size()];
        byte[] crystalZ = new byte[this.crystals.size()];
        int i = 0;
        for (BlockPos crystal : this.crystals) {
            crystalX[i] = (byte)crystal.m_123341_();
            crystalY[i] = (byte)crystal.m_123342_();
            crystalZ[i] = (byte)crystal.m_123343_();
            ++i;
        }
        tagCompound.m_128382_("crystalsX", crystalX);
        tagCompound.m_128382_("crystalsY", crystalY);
        tagCompound.m_128382_("crystalsZ", crystalZ);
        tagCompound.m_128379_("lasersActive", this.lasersActive);
        tagCompound.m_128405_("laserStartup", this.laserStartup);
    }

    public Set<BlockPos> getCrystals() {
        return this.crystals;
    }
}

