/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import java.awt.Rectangle;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.ValveTileEntity;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ValveGui
extends GenericGuiContainer<ValveTileEntity, GenericContainer> {
    public static final int VALVE_WIDTH = 180;
    public static final int VALVE_HEIGHT = 152;
    private static final ResourceLocation iconLocation = new ResourceLocation("deepresonance", "textures/gui/valve.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("deepresonance", "textures/gui/guielements.png");
    private TextField minPurity;
    private TextField minStrength;
    private TextField minEfficiency;
    private TextField maxAmount;

    public ValveGui(ValveTileEntity tileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)tileEntity, (AbstractContainerMenu)container, inventory, ManualEntry.EMPTY);
        this.f_97726_ = 180;
        this.f_97727_ = 152;
    }

    private ImageChoiceLabel initRedstoneMode() {
        ImageChoiceLabel redstoneMode = ((ImageChoiceLabel)new ImageChoiceLabel().name("redstone")).choice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).choice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).choice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        redstoneMode.hint((LayoutHint)new PositionalLayout.PositionalHint(154, 47, 16, 16));
        return redstoneMode;
    }

    public void m_7856_() {
        super.m_7856_();
        Panel toplevel = ((Panel)new Panel().background(iconLocation)).layout((Layout)new PositionalLayout());
        Panel inputPanel = this.setupInputPanel();
        Panel outputPanel = this.setupOutputPanel();
        Button applyButton = (Button)((Button)((Button)((Button)new Button().channel("apply")).text("Apply")).tooltips(new String[]{"Apply the new setting"})).hint((LayoutHint)new PositionalLayout.PositionalHint(112, 49, 40, 14));
        ImageChoiceLabel redstoneMode = this.initRedstoneMode();
        toplevel.children(new Widget[]{inputPanel, outputPanel, applyButton, redstoneMode});
        toplevel.setBounds(new Rectangle(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.bind("redstone", (GenericTileEntity)((ValveTileEntity)this.tileEntity), GenericTileEntity.VALUE_RSMODE.name());
        this.window.event("apply", (source, params) -> this.updateSettings());
    }

    private Panel setupOutputPanel() {
        this.maxAmount = (TextField)((TextField)((TextField)new TextField().tooltips(new String[]{"The maximum amount of liquid", "in the bottom tank"})).text(Integer.toString(((ValveTileEntity)this.tileEntity).getMaxMb())).desiredWidth(45)).desiredHeight(15);
        return (Panel)((Panel)((Panel)((Panel)((Panel)new Panel().layout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(2)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{((Label)((Label)new Label().text("Max mb")).desiredWidth(50)).desiredHeight(15)})).children(new Widget[]{this.maxAmount})).hint((LayoutHint)new PositionalLayout.PositionalHint(112, 6, 60, 40));
    }

    private Panel setupInputPanel() {
        this.minPurity = (TextField)((TextField)((TextField)new TextField().tooltips(new String[]{"The minimum purity % to", "accept the liquid"})).text(Integer.toString((int)(((ValveTileEntity)this.tileEntity).getMinPurity() * 100.0f))).desiredWidth(30)).desiredHeight(15);
        this.minStrength = (TextField)((TextField)((TextField)new TextField().tooltips(new String[]{"The minimum strength % to", "accept the liquid"})).text(Integer.toString((int)(((ValveTileEntity)this.tileEntity).getMinStrength() * 100.0f))).desiredWidth(30)).desiredHeight(15);
        this.minEfficiency = (TextField)((TextField)((TextField)new TextField().tooltips(new String[]{"The minimum efficiency % to", "accept the liquid"})).text(Integer.toString((int)(((ValveTileEntity)this.tileEntity).getMinEfficiency() * 100.0f))).desiredWidth(30)).desiredHeight(15);
        Panel purityPanel = (Panel)((Panel)((Panel)new Panel().layout((Layout)new HorizontalLayout()).desiredHeight(16)).children(new Widget[]{((Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).text("Purity")).desiredWidth(50)})).children(new Widget[]{this.minPurity});
        Panel strengthPanel = (Panel)((Panel)((Panel)new Panel().layout((Layout)new HorizontalLayout()).desiredHeight(16)).children(new Widget[]{((Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).text("Strength")).desiredWidth(50)})).children(new Widget[]{this.minStrength});
        Panel efficiencyPanel = (Panel)((Panel)((Panel)new Panel().layout((Layout)new HorizontalLayout()).desiredHeight(16)).children(new Widget[]{((Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).text("Efficiency")).desiredWidth(50)})).children(new Widget[]{this.minEfficiency});
        return (Panel)((Panel)((Panel)((Panel)new Panel().layout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(3)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{purityPanel, strengthPanel, efficiencyPanel})).hint((LayoutHint)new PositionalLayout.PositionalHint(9, 6, 100, 58));
    }

    private void updateSettings() {
        int purity = 0;
        try {
            purity = Integer.parseInt(this.minPurity.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int strength = 0;
        try {
            strength = Integer.parseInt(this.minStrength.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int efficiency = 0;
        try {
            efficiency = Integer.parseInt(this.minEfficiency.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int maxMb = 0;
        try {
            maxMb = Integer.parseInt(this.maxAmount.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setValue(ValveTileEntity.VALUE_MINPURITY, Float.valueOf((float)purity / 100.0f));
        this.setValue(ValveTileEntity.VALUE_STRENGTH, Float.valueOf((float)strength / 100.0f));
        this.setValue(ValveTileEntity.VALUE_EFFICIENCY, Float.valueOf((float)efficiency / 100.0f));
        this.setValue(ValveTileEntity.VALUE_MAXMB, maxMb);
    }

    public static void register() {
        ValveGui.register(MachinesModule.VALVE_CONTAINER.get(), ValveGui::new);
    }
}

