/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.item;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.items.GenericArmorMaterial;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.crafting.Ingredient;

public class ResonatingMaterial
implements GenericArmorMaterial {
    private static final int[] HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    public ResonatingMaterial(String name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public int getDurabilityForType(EquipmentSlot type) {
        return HEALTH_PER_SLOT[type.m_20749_()] * this.durabilityMultiplier;
    }

    public int getDefenseForType(EquipmentSlot type) {
        return this.slotProtections[type.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @Nonnull
    public SoundEvent m_7344_() {
        return this.sound;
    }

    @Nonnull
    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    @Nonnull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }
}

