/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.data;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.modules.tank.data.TankFixer;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.IMultiblockFixer;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;

public class DRTankNetwork
extends AbstractWorldData<DRTankNetwork> {
    private static final String TANK_NETWORK_NAME = "DRTankNetwork";
    public static final ResourceLocation TANK_NETWORK_ID = new ResourceLocation("deepresonance", "tank");
    private final MultiblockDriver<TankBlob> driver = MultiblockDriver.builder().loader(TankBlob::load).saver(TankBlob::save).dirtySetter(d -> this.m_77762_()).mergeChecker((b1, b2) -> DRTankNetwork.isCompatible(b1.getData(), b2.getData())).fixer((IMultiblockFixer)new TankFixer()).holderGetter((world, blockPos) -> {
        IMultiblockConnector connector;
        BlockEntity be = world.m_7702_(blockPos);
        if (be instanceof IMultiblockConnector && TANK_NETWORK_ID.equals((Object)(connector = (IMultiblockConnector)be).getId())) {
            return connector;
        }
        return null;
    }).build();

    public static void foreach(Level level, int blobId, Consumer<BlockPos> consumer, BlockPos current) {
        MultiblockDriver<TankBlob> driver = DRTankNetwork.getNetwork(level).getDriver();
        DRTankNetwork.foreach(level, blobId, consumer, driver, current, new HashSet<BlockPos>());
    }

    private static void foreach(Level level, int blobId, Consumer<BlockPos> consumer, MultiblockDriver<TankBlob> driver, BlockPos current, Set<BlockPos> done) {
        if (done.contains(current)) {
            return;
        }
        IMultiblockConnector connector = (IMultiblockConnector)driver.getHolderGetter().apply(level, current);
        if (connector != null && connector.getId() == TANK_NETWORK_ID && connector.getMultiblockId() == blobId) {
            done.add(current);
            consumer.accept(current);
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                DRTankNetwork.foreach(level, blobId, consumer, driver, current.m_121945_(direction), done);
            }
        }
    }

    public static boolean isCompatible(@Nonnull LiquidCrystalData data1, @Nonnull LiquidCrystalData data2) {
        Fluid fluid2;
        if (data1.getFluidStack().isEmpty() || data2.getFluidStack().isEmpty()) {
            return true;
        }
        Fluid fluid1 = data1.getFluidStack().getFluid();
        return fluid1 == (fluid2 = data2.getFluidStack().getFluid());
    }

    public DRTankNetwork() {
    }

    public DRTankNetwork(CompoundTag tag) {
        this.driver.load(tag);
    }

    public void clear() {
        this.driver.clear();
    }

    public MultiblockDriver<TankBlob> getDriver() {
        return this.driver;
    }

    public static DRTankNetwork getNetwork(Level world) {
        return (DRTankNetwork)DRTankNetwork.getData((Level)world, DRTankNetwork::new, DRTankNetwork::new, (String)TANK_NETWORK_NAME);
    }

    public TankBlob getBlob(int id) {
        return (TankBlob)this.driver.get(id);
    }

    public TankBlob getOrCreateBlob(int id) {
        TankBlob network = this.getBlob(id);
        if (network == null) {
            network = new TankBlob().setTankBlocks(0);
            this.driver.createOrUpdate(id, (IMultiblock)network);
        }
        return network;
    }

    public void deleteBlob(int id) {
        this.driver.delete(id);
    }

    public int newBlob() {
        return this.driver.createId();
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tagCompound) {
        return this.driver.save(tagCompound);
    }
}

