/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.worldgen.world;

import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.worldgen.util.WorldGenConfiguration;
import mcjty.deepresonance.modules.worldgen.world.ResonantCrystalFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ResonantCrystalFeature
extends Feature<ResonantCrystalFeatureConfig> {
    public static final ResourceLocation FEATURE_CRYSTAL_ID = new ResourceLocation("deepresonance", "resonant_crystal");

    public ResonantCrystalFeature(Codec<ResonantCrystalFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ResonantCrystalFeatureConfig> context) {
        if (context.m_225041_().m_188500_() < (Double)WorldGenConfiguration.CRYSTAL_SPAWN_CHANCE.get()) {
            return this.trySpawnCrystal(context.m_159774_(), context.m_159775_(), new ChunkPos(context.m_159777_()), context.m_225041_(), (ResonantCrystalFeatureConfig)context.m_159778_());
        }
        return false;
    }

    private boolean trySpawnCrystal(@Nonnull WorldGenLevel world, @Nonnull ChunkGenerator generator, ChunkPos chunkPos, RandomSource random, ResonantCrystalFeatureConfig config) {
        for (int i = 0; i < (Integer)WorldGenConfiguration.CRYSTAL_SPAWN_TRIES.get(); ++i) {
            BlockPos pos = new BlockPos(chunkPos.m_45604_() + random.m_188503_(16), 0, chunkPos.m_45605_() + random.m_188503_(16));
            int y = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
            pos = new BlockPos(pos.m_123341_(), y - 1, pos.m_123343_());
            BlockPos.MutableBlockPos poz = pos.m_122032_();
            while (poz.m_123342_() > world.m_141937_() && !world.m_8055_((BlockPos)poz).m_60795_()) {
                poz.m_122173_(Direction.DOWN);
            }
            while (poz.m_123342_() > world.m_141937_() && world.m_8055_((BlockPos)poz).m_60795_()) {
                poz.m_122173_(Direction.DOWN);
            }
            if (!world.m_8055_((BlockPos)poz).m_60838_((BlockGetter)world, (BlockPos)poz) || !world.m_8055_(pos = poz.m_7494_()).m_60795_()) continue;
            if (((Boolean)WorldGenConfiguration.VERBOSE.get()).booleanValue()) {
                DeepResonance.setup.getLogger().info("Spawned crystal at: " + String.valueOf(pos));
            }
            ResonantCrystalFeature.spawnRandomCrystal(world, random, pos, config.strength, config.power, config.efficiency, config.purity);
            return true;
        }
        return false;
    }

    public static void spawnRandomCrystal(WorldGenLevel world, RandomSource random, BlockPos pos, float str, float pow, float eff, float pur) {
        world.m_7731_(pos, ((ResonatingCrystalBlock)CoreModule.RESONATING_CRYSTAL_NATURAL.get()).m_49966_(), 3);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity tile = (ResonatingCrystalTileEntity)te;
            tile.setStrength(Math.min(100.0f, random.m_188501_() * str * 3.0f + 0.01f));
            tile.setPower(Math.min(100.0f, random.m_188501_() * pow * 60.0f + 0.2f));
            tile.setEfficiency(Math.min(100.0f, random.m_188501_() * eff * 3.0f + 0.1f));
            tile.setPurity(Math.min(100.0f, random.m_188501_() * pur * 10.0f + 5.0f));
        }
    }
}

