/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import java.util.function.Supplier;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.pedestal.PedestalModule;
import mcjty.deepresonance.modules.radiation.RadiationModule;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.worldgen.WorldGenModule;
import mcjty.deepresonance.setup.Config;
import mcjty.deepresonance.setup.DeepResonanceMessages;
import mcjty.deepresonance.setup.ModSetup;
import mcjty.deepresonance.setup.Registration;
import mcjty.deepresonance.util.DeepResonanceTags;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="deepresonance")
public class DeepResonance {
    public static final String MODID = "deepresonance";
    public static final String SHIFT_MESSAGE = "message.deepresonance.shiftmessage";
    public static DeepResonance instance;
    public static ModSetup setup;
    private final Modules modules = new Modules();

    public DeepResonance(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        setup = new ModSetup();
        DeepResonanceTags.init();
        this.setupModules(bus);
        Config.register(mod, bus, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::onDataGen);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        bus.addListener(DeepResonanceMessages::registerMessages);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        datagen.generate();
    }

    private void setupModules(IEventBus bus) {
        this.modules.register((IModule)new CoreModule());
        this.modules.register((IModule)new GeneratorModule());
        this.modules.register((IModule)new MachinesModule(bus));
        this.modules.register((IModule)new RadiationModule());
        this.modules.register((IModule)new TankModule());
        this.modules.register((IModule)new WorldGenModule());
        this.modules.register((IModule)new PedestalModule(bus));
    }
}

