/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import java.util.Map;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.deepresonance.modules.radiation.manager.QuadTree;
import mcjty.deepresonance.modules.radiation.util.RadiationShieldRegistry;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        Level world = event.getPlayer().level();
        if (world.isClientSide) {
            return;
        }
        float blocker = (float)RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalPos, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getPos().getX();
        int y = event.getPos().getY();
        int z = event.getPos().getZ();
        for (Map.Entry<GlobalPos, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalPos gc = entry.getKey();
            BlockPos c = gc.pos();
            if (!((float)Math.abs(c.getX() - x) < radius) || !((float)Math.abs(c.getY() - y) < radius) || !((float)Math.abs(c.getZ() - z) < radius)) continue;
            Logging.logDebug((String)("Removed blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.getX(), c.getY(), c.getZ());
            radiationTree.addBlocker(x, y, z, 1.0f);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        float blocker = (float)RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        Level world = event.getEntity().level();
        if (world.isClientSide()) {
            return;
        }
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalPos, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getBlockSnapshot().getPos().getX();
        int y = event.getBlockSnapshot().getPos().getY();
        int z = event.getBlockSnapshot().getPos().getZ();
        for (Map.Entry<GlobalPos, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalPos gc = entry.getKey();
            BlockPos c = gc.pos();
            if (!((float)Math.abs(c.getX() - x) < radius) || !((float)Math.abs(c.getY() - y) < radius) || !((float)Math.abs(c.getZ() - z) < radius)) continue;
            Logging.logDebug((String)("Add blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.getX(), c.getY(), c.getZ());
            radiationTree.addBlocker(x, y, z, blocker);
        }
    }
}

