/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.jei.smelter;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.deepresonance.compat.jei.DeepResonanceJeiPlugin;
import mcjty.deepresonance.compat.jei.smelter.SmelterRecipeWrapper;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.SmelterConfig;
import mcjty.lib.varia.ComponentFactory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class SmelterRecipeCategory
implements IRecipeCategory<SmelterRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final IDrawable icon;
    private final IDrawable background;
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"smelter");

    public SmelterRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MachinesModule.SMELTER.block().get()));
        this.arrow = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"textures/gui/guielements.png"), 144, 0, 16, 16);
        this.background = guiHelper.createBlankDrawable(120, 60);
    }

    @Nonnull
    public Component getTitle() {
        return ComponentFactory.literal((String)"Deep Resonance Smelter");
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<SmelterRecipeWrapper> getRecipeType() {
        return DeepResonanceJeiPlugin.SMELTER_RECIPE;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(SmelterRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slot.draw(graphics, 20, 32);
        this.arrow.draw(graphics, 46, 32);
        Font fontRenderer = Minecraft.getInstance().font;
        graphics.drawString(fontRenderer, "Tank below between", 10, 0, -1);
        graphics.drawString(fontRenderer, "40% and 60% lava", 10, 10, -1);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmelterRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 32).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)CoreModule.RESONATING_ORE_DEEPSLATE.block().get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_END.block().get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_NETHER.block().get()), new ItemStack((ItemLike)CoreModule.RESONATING_ORE_STONE.block().get())));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 25).setFluidRenderer((long)((Integer)SmelterConfig.RCL_PER_ORE.get()).intValue(), true, 30, 30).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, List.of(new FluidStack(CoreModule.LIQUID_CRYSTAL.get(), ((Integer)SmelterConfig.RCL_PER_ORE.get()).intValue())))).addTooltipCallback((view, tooltip) -> {
            tooltip.add(ComponentFactory.literal((String)"Purity: 10%").withStyle(ChatFormatting.GREEN));
            tooltip.add(ComponentFactory.literal((String)"Strength: 10%").withStyle(ChatFormatting.GREEN));
            tooltip.add(ComponentFactory.literal((String)"Efficiency: 10%").withStyle(ChatFormatting.GREEN));
        });
    }
}

