/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.block;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.compat.DeepResonanceTOPDriver;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.core.data.Crystal;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ExplosionTools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResonatingCrystalBlock
extends BaseBlock {
    private static final VoxelShape AABB = Shapes.box((double)0.1f, (double)0.0, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f);
    private final boolean generated;
    private final boolean empty;

    public ResonatingCrystalBlock(boolean generated, boolean empty) {
        super(new BlockBuilder().topDriver((TOPDriver)DeepResonanceTOPDriver.DRIVER).properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).noOcclusion()).tileEntitySupplier(ResonatingCrystalTileEntity::new));
        this.generated = generated;
        this.empty = empty;
    }

    public ResonatingCrystalBlock getEmpty() {
        if (this.generated) {
            return (ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED_EMPTY.block().get());
        }
        return (ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_NATURAL_EMPTY.block().get());
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return AABB;
    }

    public RotationType getRotationType() {
        return RotationType.HORIZROTATION;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof ResonatingCrystalTileEntity) {
            return this.createStack((ResonatingCrystalTileEntity)tile);
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack createStack(ResonatingCrystalTileEntity crystal) {
        ItemStack ret = new ItemStack((ItemLike)this);
        Crystal data = (Crystal)crystal.getData((Supplier)CoreModule.CRYSTAL_DATA);
        HolderLookup.Provider provider = crystal.getLevel() != null ? crystal.getLevel().registryAccess() : ResonatingCrystalBlock.builtInProvider();
        ret.set(CoreModule.ITEM_CRYSTAL_DATA, (Object)data);
        return ret;
    }

    public List<ItemStack> getItemsForTab() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ResonatingCrystalTileEntity crystal = new ResonatingCrystalTileEntity(BlockPos.ZERO, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.block().get())).defaultBlockState());
        for (int power : new int[]{0, 50}) {
            for (int purity : new int[]{0, 50}) {
                crystal.setPurity(purity);
                crystal.setPower(power);
                items.add(this.createStack(crystal));
            }
        }
        return items;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.isClientSide) {
            ResonatingCrystalBlock.explode(world, pos);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    private static void explodeHelper(Level world, BlockPos location, float radius) {
        Explosion boom = ExplosionTools.explodeFullDestroy((Level)world, (BlockPos)location, (float)radius);
        int x = (int)(-radius);
        while ((float)x < radius) {
            int y = (int)(-radius);
            while ((float)y < radius) {
                int z = (int)(-radius);
                while ((float)z < radius) {
                    BlockPos targetPosition = location.offset(x, y, z);
                    double dist = Math.sqrt(location.distSqr((Vec3i)targetPosition));
                    if (dist < (double)radius) {
                        BlockState state = world.getBlockState(targetPosition);
                        Block block = state.getBlock();
                        float resistance = state.getExplosionResistance((BlockGetter)world, targetPosition, boom);
                        if (!state.isAir() && resistance > 0.0f && (dist < (double)(radius - 1.0f) || (double)world.random.nextFloat() > 0.7)) {
                            block.onBlockExploded(state, world, targetPosition, boom);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void explode(Level world, BlockPos pos) {
        BlockEntity theCrystalTile = world.getBlockEntity(pos);
        world.getServer().tell((Runnable)new TickTask((int)(world.getGameTime() + 1L), () -> {
            double forceMultiplier = 1.0;
            if (theCrystalTile instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)theCrystalTile;
                float explosionStrength = (float)(crystal.getPower() * crystal.getStrength() / 10000.0);
                forceMultiplier = (double)explosionStrength * ((Double)RadiationConfiguration.MAXIMUM_EXPLOSION_MULTIPLIER.get() - (Double)RadiationConfiguration.MINIMUM_EXPLOSION_MULTIPLIER.get()) + (Double)RadiationConfiguration.MINIMUM_EXPLOSION_MULTIPLIER.get();
                if (forceMultiplier > (Double)RadiationConfiguration.ABSOLUTE_MAXIMUM_EXPLOSION_MULTIPLIER.get()) {
                    forceMultiplier = (Double)RadiationConfiguration.ABSOLUTE_MAXIMUM_EXPLOSION_MULTIPLIER.get();
                }
                if (forceMultiplier > (double)0.001f) {
                    DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
                    DRRadiationManager.RadiationSource source = radiationManager.getOrCreateRadiationSource(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
                    double radiationRadius = DRRadiationManager.calculateRadiationRadius(crystal.getStrength(), crystal.getEfficiency(), crystal.getPurity());
                    double radiationStrength = DRRadiationManager.calculateRadiationStrength(crystal.getStrength(), crystal.getPurity());
                    source.update((float)(radiationRadius * (Double)RadiationConfiguration.RADIATION_EXPLOSION_FACTOR.get()), (float)(radiationStrength / (Double)RadiationConfiguration.RADIATION_EXPLOSION_FACTOR.get()), 1000);
                }
            }
            if (forceMultiplier > (double)0.001f) {
                ResonatingCrystalBlock.explodeHelper(world, pos, (float)forceMultiplier);
            }
        }));
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        Crystal data = (Crystal)stack.get(CoreModule.ITEM_CRYSTAL_DATA);
        double power = 100.0;
        if (data != null) {
            power = data.power();
        }
        if (power > (double)1.0E-5f) {
            tooltip.add((Component)ComponentFactory.translatable((String)"message.deepresonance.crystal_power"));
        } else {
            tooltip.add((Component)ComponentFactory.translatable((String)"message.deepresonance.crystal_empty"));
        }
        if (data != null) {
            ResonatingCrystalBlock.addBasicInformation(tooltip::add, data, power, true);
        }
    }

    private static void addBasicInformation(Consumer<Component> tooltip, Crystal data, double power, boolean showPower) {
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        tooltip.accept((Component)ComponentFactory.translatable((String)"message.deepresonance.crystal_sep").withStyle(ChatFormatting.GREEN).append(": " + decimalFormat.format(data.strength()) + "% " + decimalFormat.format(data.efficiency()) + "% " + decimalFormat.format(data.purity()) + "%"));
        if (showPower) {
            tooltip.accept((Component)ComponentFactory.literal((String)("Power left: " + decimalFormat.format(power) + "%")).withStyle(ChatFormatting.YELLOW));
        }
    }

    private static HolderLookup.Provider builtInProvider() {
        return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY).freeze();
    }
}

