/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.block;

import java.util.function.Supplier;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.data.Crystal;
import mcjty.deepresonance.modules.core.data.ResonatingCrystalData;
import mcjty.deepresonance.modules.core.util.CrystalConfig;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ResonatingCrystalTileEntity
extends GenericTileEntity {
    private float powerPerTick = -1.0f;
    private int rfPerTick = -1;

    public ResonatingCrystalTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CoreModule.TYPE_RESONATING_CRYSTAL.get(), pos, state);
    }

    public double getStrength() {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        return data.strength();
    }

    public double getPower() {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        return data.power();
    }

    public double getEfficiency() {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        return data.efficiency();
    }

    public double getPurity() {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        return data.purity();
    }

    public boolean isGlowing() {
        ResonatingCrystalData data = (ResonatingCrystalData)this.getData((Supplier)CoreModule.RESONATING_CRYSTAL_DATA);
        return data.glowing();
    }

    public void setStrength(double strength) {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        data = data.withStrength(strength);
        this.setData((Supplier)CoreModule.CRYSTAL_DATA, data);
    }

    public boolean isEmpty() {
        return this.getPower() < (double)1.0E-5f;
    }

    public void setPower(double power) {
        boolean oldempty = this.isEmpty();
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        data = data.withPower(power);
        this.setData((Supplier)CoreModule.CRYSTAL_DATA, data);
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            Block block;
            if (this.level != null && (block = this.getBlockState().getBlock()) instanceof ResonatingCrystalBlock) {
                ResonatingCrystalBlock crystalBlock = (ResonatingCrystalBlock)block;
                this.level.setBlock(this.worldPosition, this.getBlockState(), 11);
            }
            this.setChanged();
        }
    }

    public float getPowerPerTick() {
        if (this.powerPerTick < 0.0f) {
            double totalRF = ResonatingCrystalTileEntity.getTotalPower(this.getStrength(), this.getPurity());
            double numticks = totalRF / (double)ResonatingCrystalTileEntity.getRfPerTick(this.getEfficiency(), this.getPurity());
            this.powerPerTick = (float)(100.0 / numticks);
        }
        return this.powerPerTick;
    }

    public static double getTotalPower(double strength, double purity) {
        return 1000.0 * (double)((Integer)CrystalConfig.MAX_POWER_STORED.get()).intValue() * strength / 100.0 * (purity + 30.0) / 130.0;
    }

    public int getRfPerTick() {
        if (this.rfPerTick == -1) {
            this.rfPerTick = ResonatingCrystalTileEntity.getRfPerTick(this.getEfficiency(), this.getPurity());
        }
        return this.rfPerTick;
    }

    public static int getRfPerTick(double efficiency, double purity) {
        return (int)((double)((Integer)CrystalConfig.MAX_POWER_TICK.get()).intValue() * efficiency / 100.1 * (purity + 2.0) / 102.0 + 1.0);
    }

    public void setEfficiency(double efficiency) {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        data = data.withEfficiency(efficiency);
        this.setData((Supplier)CoreModule.CRYSTAL_DATA, data);
    }

    public void setPurity(double purity) {
        Crystal data = (Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA);
        data = data.withPurity(purity);
        this.setData((Supplier)CoreModule.CRYSTAL_DATA, data);
    }

    public void setGlowing(boolean glowing) {
        ResonatingCrystalData data = (ResonatingCrystalData)this.getData((Supplier)CoreModule.RESONATING_CRYSTAL_DATA);
        if (data.glowing() == glowing) {
            return;
        }
        data = data.withGlowing(glowing);
        this.setData((Supplier)CoreModule.RESONATING_CRYSTAL_DATA, data);
        this.markDirtyClient();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        boolean oldempty = this.isEmpty();
        super.onDataPacket(net, packet, provider);
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.setGlowing(tagCompound.getBoolean("glowing"));
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.putBoolean("glowing", this.isGlowing());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(CoreModule.ITEM_RESONATING_CRYSTAL_DATA, (Object)((ResonatingCrystalData)this.getData((Supplier)CoreModule.RESONATING_CRYSTAL_DATA)));
        components.set(CoreModule.ITEM_CRYSTAL_DATA, (Object)((Crystal)this.getData((Supplier)CoreModule.CRYSTAL_DATA)));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        Crystal cdata;
        super.applyImplicitComponents(input);
        ResonatingCrystalData rcdata = (ResonatingCrystalData)input.get(CoreModule.ITEM_RESONATING_CRYSTAL_DATA);
        if (rcdata != null) {
            this.setData((Supplier)CoreModule.RESONATING_CRYSTAL_DATA, rcdata);
        }
        if ((cdata = (Crystal)input.get(CoreModule.ITEM_CRYSTAL_DATA)) != null) {
            this.setData((Supplier)CoreModule.CRYSTAL_DATA, cdata);
        }
    }
}

