/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.item;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.deepresonance.modules.tank.data.DRTankHandler;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ItemLiquidInjector
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));

    public ItemLiquidInjector(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, tooltip, flags);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide) {
            BlockEntity tile = world.getBlockEntity(context.getClickedPos());
            if (tile instanceof TankTileEntity) {
                TankTileEntity tank = (TankTileEntity)tile;
                DRTankHandler fluidHandler = tank.getInternalFluidHandler();
                fluidHandler.fill(LiquidCrystalData.makeLiquidCrystalStack(100, 1.0f, 0.1f, 0.1f, 0.1f), IFluidHandler.FluidAction.EXECUTE);
            } else if (context.getPlayer() != null) {
                context.getPlayer().sendSystemMessage((Component)ComponentFactory.translatable((String)"message.deepresonance.no_tank").withStyle(ChatFormatting.YELLOW));
            }
        }
        return InteractionResult.SUCCESS;
    }
}

