/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.util;

import java.util.Random;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CrystalHelper {
    public static boolean isEmpty(float power) {
        return power < 1.0E-5f;
    }

    public static void spawnCrystal(Level world, Random random, BlockPos pos, CrystalOption type) {
        float strength = 0.0f;
        float power = 0.0f;
        float efficiency = 0.0f;
        float purity = 0.0f;
        switch (type.ordinal()) {
            case 0: {
                strength = 20.0f;
                power = 100.0f;
                efficiency = 20.0f;
                purity = 20.0f;
                break;
            }
            case 1: {
                strength = 20.0f;
                power = 0.001f;
                efficiency = 20.0f;
                purity = 20.0f;
                break;
            }
            case 2: {
                strength = random.nextFloat() * 100.0f;
                power = random.nextFloat() * 100.0f;
                efficiency = random.nextFloat() * 100.0f;
                purity = random.nextFloat() * 100.0f;
                break;
            }
            case 3: {
                strength = 100.0f;
                power = 100.0f;
                efficiency = 100.0f;
                purity = 100.0f;
                break;
            }
            case 4: {
                strength = 100.0f;
                power = 100.0f;
                efficiency = 100.0f;
                purity = 1.0f;
            }
        }
        CrystalHelper.spawnCrystal(world, pos, purity, strength, efficiency, power);
    }

    private static void spawnCrystal(Level world, BlockPos pos, float purity, float strength, float efficiency, float power) {
        world.setBlock(pos, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.block().get())).defaultBlockState(), 3);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            crystal.setPurity(purity);
            crystal.setStrength(strength);
            crystal.setEfficiency(efficiency);
            crystal.setPower(power);
        }
    }

    public static enum CrystalOption implements StringRepresentable
    {
        DEFAULT,
        DEPLETED,
        RANDOM,
        MAX,
        DIRTY;


        public String getSerializedName() {
            return this.getSerializedName();
        }
    }
}

