/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator;

import java.util.function.Supplier;
import mcjty.deepresonance.datagen.BlockStates;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.generator.DataGenHelper;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorBlock;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.block.GeneratorControllerBlock;
import mcjty.deepresonance.modules.generator.block.GeneratorControllerTileEntity;
import mcjty.deepresonance.modules.generator.block.GeneratorPartBlock;
import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.client.ClientSetup;
import mcjty.deepresonance.modules.generator.client.CollectorRenderer;
import mcjty.deepresonance.modules.generator.data.GeneratorPartData;
import mcjty.deepresonance.modules.generator.util.CollectorConfig;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.deepresonance.setup.Registration;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.varia.SoundTools;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GeneratorModule
implements IModule {
    public static final RBlock<EnergyCollectorBlock, BlockItem, EnergyCollectorTileEntity> ENERGY_COLLECTOR = Registration.registerBlockWithTile("energy_collector", EnergyCollectorTileEntity.class, EnergyCollectorBlock::new, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), EnergyCollectorTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<EnergyCollectorTileEntity>> TYPE_ENERGY_COLLECTOR = ENERGY_COLLECTOR.be();
    public static final RBlock<GeneratorControllerBlock, BlockItem, GeneratorControllerTileEntity> GENERATOR_CONTROLLER = Registration.registerBlockWithTile("generator_controller", GeneratorControllerTileEntity.class, GeneratorControllerBlock::new, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), GeneratorControllerTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<GeneratorControllerTileEntity>> TYPE_GENERATOR_CONTROLLER = GENERATOR_CONTROLLER.be();
    public static final RBlock<GeneratorPartBlock, BlockItem, GeneratorPartTileEntity> GENERATOR_PART = Registration.registerBlockWithTile("generator_part", GeneratorPartTileEntity.class, GeneratorPartBlock::new, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), GeneratorPartTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<GeneratorPartTileEntity>> TYPE_GENERATOR_PART = GENERATOR_PART.be();
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<GeneratorPartData>> GENERATOR_PART_DATA = Registration.ATTACHMENT_TYPES.register("generator_part", () -> AttachmentType.builder(() -> GeneratorPartData.DEFAULT).serialize(GeneratorPartData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<GeneratorPartData>> ITEM_GENERATOR_PART_DATA = Registration.COMPONENTS.registerComponentType("generator_part", builder -> builder.persistent(GeneratorPartData.CODEC).networkSynchronized(GeneratorPartData.STREAM_CODEC));
    public static final Supplier<SoundEvent> STARTUP_SOUND = Registration.SOUNDS.register("engine_start", () -> SoundTools.createSoundEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"engine_start")));
    public static final Supplier<SoundEvent> LOOP_SOUND = Registration.SOUNDS.register("engine_loop", () -> SoundTools.createSoundEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"engine_loop")));
    public static final Supplier<SoundEvent> SHUTDOWN_SOUND = Registration.SOUNDS.register("engine_shutdown", () -> SoundTools.createSoundEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"engine_shutdown")));

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
        ClientSetup.initClient();
        CollectorRenderer.register();
    }

    public void initConfig(IEventBus bus) {
        CollectorConfig.init();
        GeneratorConfig.init();
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider lookupProvider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(GENERATOR_PART).blockState(provider -> DataGenHelper.registerGeneratorPart((Supplier<? extends Block>)GENERATOR_PART.block(), provider)).parentedItem().standardLoot(new DataComponentType[]{(DataComponentType)ITEM_GENERATOR_PART_DATA.get()}).ironPickaxeTags().shaped(builder -> builder.define(Character.valueOf('P'), (ItemLike)CoreModule.RESONATING_PLATE_ITEM.get()).define(Character.valueOf('X'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"XRX", "imi", "PRP"}), Dob.blockBuilder(ENERGY_COLLECTOR).blockState(provider -> provider.simpleBlock((Block)ENERGY_COLLECTOR.block().get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent("energy_collector", ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"collector"))).texture("collector_texture", "deepresonance:block/energy_collector")).texture("particle", "deepresonance:block/energy_collector"))).parentedItem().simpleLoot().ironPickaxeTags().shaped(builder -> builder.define(Character.valueOf('X'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('P'), (ItemLike)CoreModule.RESONATING_PLATE_ITEM.get()).define(Character.valueOf('q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"PdP", "qmq", "XXX"}), Dob.blockBuilder(GENERATOR_CONTROLLER).blockState(provider -> provider.horizontalOrientedBlock((Block)GENERATOR_CONTROLLER.block().get(), (state, builder) -> {
            if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
                builder.modelFile(provider.frontBasedModel(provider.name(state.getBlock()), ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/generator_controller_on"), BlockStates.DEFAULT_SIDE, BlockStates.DEFAULT_TOP, BlockStates.DEFAULT_BOTTOM));
            } else {
                builder.modelFile(provider.frontBasedModel(provider.name(state.getBlock()), ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/generator_controller"), BlockStates.DEFAULT_SIDE, BlockStates.DEFAULT_TOP, BlockStates.DEFAULT_BOTTOM));
            }
        })).parentedItem().simpleLoot().ironPickaxeTags().shaped(builder -> builder.define(Character.valueOf('P'), (ItemLike)CoreModule.RESONATING_PLATE_ITEM.get()).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"RCR", "imi", "PiP"})});
    }
}

