/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.data.DRGeneratorNetwork;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.util.CollectorConfig;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnergyCollectorTileEntity
extends TickingTileEntity {
    public static final float CRYSTAL_MIN_POWER = 1.0E-5f;
    public static final int MAXTICKS = 20;
    private Set<BlockPos> crystals = new HashSet<BlockPos>();
    private boolean lasersActive = false;
    private int laserStartup = 0;
    private int radiationUpdateCount = 20;
    private int blobId = -1;
    private static final int ERROR_TOOMANYCRYSTALS = -1;
    private static final int ERROR_TOOMUCHPOWER = -2;

    public EnergyCollectorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GeneratorModule.TYPE_ENERGY_COLLECTOR.get(), pos, state);
    }

    public void tickServer() {
        boolean active = false;
        int startup = 0;
        GeneratorBlob network = null;
        BlockEntity te = this.level.getBlockEntity(this.getBlockPos().below());
        if (te instanceof GeneratorPartTileEntity) {
            GeneratorPartTileEntity generator = (GeneratorPartTileEntity)te;
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.level);
            if (this.blobId != generator.getMultiblockId()) {
                if (this.blobId != -1) {
                    this.getDriver().modify(this.blobId, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
                }
                this.blobId = generator.getMultiblockId();
                this.getDriver().modify(this.blobId, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
                generatorNetwork.save();
            }
            int multiblockId = generator.getMultiblockId();
            network = generator.getBlob();
            if (network != null) {
                if (network.isActive()) {
                    this.getDriver().modify(multiblockId, holder -> {
                        int rfPerTick = this.calculateRF();
                        ((GeneratorBlob)holder.getMb()).setLastRfPerTick(rfPerTick);
                        int newEnergy = ((GeneratorBlob)holder.getMb()).getEnergy() + rfPerTick;
                        int maxEnergy = ((GeneratorBlob)holder.getMb()).getGeneratorBlocks() * (Integer)GeneratorConfig.POWER_STORAGE_PER_BLOCK.get();
                        if (newEnergy > maxEnergy) {
                            newEnergy = maxEnergy;
                        }
                        if (((GeneratorBlob)holder.getMb()).getEnergy() != newEnergy) {
                            ((GeneratorBlob)holder.getMb()).setEnergy(newEnergy);
                            generatorNetwork.save();
                        }
                    });
                    active = true;
                } else {
                    this.getDriver().modify(multiblockId, holder -> ((GeneratorBlob)holder.getMb()).setLastRfPerTick(0));
                }
                startup = network.getStartupCounter();
            }
        } else if (this.blobId != -1) {
            this.blobId = -1;
            this.setChanged();
        }
        if (active != this.lasersActive || startup != this.laserStartup) {
            boolean doFind = this.lasersActive != active || this.laserStartup > (Integer)GeneratorConfig.STARTUP_TIME.get() - 5;
            this.lasersActive = active;
            this.laserStartup = startup;
            this.markDirtyClient();
            if (doFind && te instanceof GeneratorPartTileEntity) {
                this.findCrystals(network);
            }
        }
    }

    public void disableCrystalGlow() {
        for (BlockPos coordinate : this.crystals) {
            BlockEntity te = this.level.getBlockEntity(new BlockPos(this.getBlockPos().getX() + coordinate.getX(), this.getBlockPos().getY() + coordinate.getY(), this.getBlockPos().getZ() + coordinate.getZ()));
            if (!(te instanceof ResonatingCrystalTileEntity)) continue;
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            crystal.setGlowing(false);
        }
    }

    public int getLaserStartup() {
        return this.laserStartup;
    }

    public boolean areLasersActive() {
        return this.lasersActive;
    }

    private MultiblockDriver<GeneratorBlob> getDriver() {
        return DRGeneratorNetwork.getNetwork(this.level).getDriver();
    }

    private int calculateRF() {
        HashSet<BlockPos> tokeep = new HashSet<BlockPos>();
        boolean dirty = false;
        float radiationRadius = 0.0f;
        float radiationStrength = 0.0f;
        boolean doRadiation = false;
        --this.radiationUpdateCount;
        if (this.radiationUpdateCount <= 0) {
            this.radiationUpdateCount = 20;
            doRadiation = true;
        }
        int rf = 0;
        for (BlockPos coordinate : this.crystals) {
            BlockEntity te = this.getLevel().getBlockEntity(new BlockPos(this.getBlockPos().getX() + coordinate.getX(), this.getBlockPos().getY() + coordinate.getY(), this.getBlockPos().getZ() + coordinate.getZ()));
            if (te instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
                if (crystal.getPower() > (double)1.0E-5f) {
                    crystal.setGlowing(this.lasersActive);
                    tokeep.add(coordinate);
                    double power = crystal.getPower();
                    if (power < (double)crystal.getPowerPerTick()) {
                        crystal.setPower(0.0);
                        continue;
                    }
                    crystal.setPower(power -= (double)crystal.getPowerPerTick());
                    int rfPerTick = crystal.getRfPerTick();
                    rf += rfPerTick;
                    if (!doRadiation) continue;
                    double purity = crystal.getPurity();
                    float radius = DRRadiationManager.calculateRadiationRadius(crystal.getStrength(), crystal.getEfficiency(), purity);
                    if (radius > radiationRadius) {
                        radiationRadius = radius;
                    }
                    float strength = DRRadiationManager.calculateRadiationStrength(crystal.getStrength(), purity);
                    radiationStrength += strength;
                    continue;
                }
                crystal.setGlowing(false);
                dirty = true;
                continue;
            }
            dirty = true;
        }
        if (dirty) {
            this.crystals = tokeep;
            this.markDirtyClient();
        }
        if (doRadiation && radiationRadius > 0.1f) {
            GlobalPos thisCoordinate;
            DRRadiationManager radiationManager = DRRadiationManager.getManager(this.getLevel());
            if (radiationManager.getRadiationSource(thisCoordinate = GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.getBlockPos())) == null) {
                Logging.log((String)("Created radiation source with radius " + radiationRadius + " and strength " + radiationStrength));
            }
            DRRadiationManager.RadiationSource radiationSource = radiationManager.getOrCreateRadiationSource(thisCoordinate);
            radiationSource.update(radiationRadius, radiationStrength, 20);
            radiationManager.save();
        }
        return rf;
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        if (!world.isClientSide() && (te = world.getBlockEntity(pos.below())) instanceof GeneratorPartTileEntity) {
            this.blobId = ((GeneratorPartTileEntity)te).getMultiblockId();
            this.getDriver().modify(this.blobId, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
        }
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        BlockEntity te = world.getBlockEntity(pos.below());
        if (te instanceof GeneratorPartTileEntity) {
            int id = ((GeneratorPartTileEntity)te).getMultiblockId();
            this.getDriver().modify(id, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(-1));
        }
    }

    private void findCrystals(GeneratorBlob network) {
        HashSet<BlockPos> newCrystals = new HashSet<BlockPos>();
        int maxSupportedRF = network.getGeneratorBlocks() * (Integer)GeneratorConfig.MAX_POWER_INPUT_PER_BLOCK.get();
        boolean tooManyCrystals = false;
        boolean tooMuchPower = false;
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        for (int y = yCoord - (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); y <= yCoord + (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); ++y) {
            if (y < this.level.getMinBuildHeight() || y >= this.level.getMaxBuildHeight()) continue;
            int maxhordist = (Integer)CollectorConfig.MAX_HORIZONTAL_CRYSTAL_DISTANCE.get();
            for (int x = xCoord - maxhordist; x <= xCoord + maxhordist; ++x) {
                for (int z = zCoord - maxhordist; z <= zCoord + maxhordist; ++z) {
                    if (!(this.level.getBlockState(new BlockPos(x, y, z)).getBlock() instanceof ResonatingCrystalBlock)) continue;
                    if ((maxSupportedRF = this.addCrystal(x, y, z, network, newCrystals, this.crystals, maxSupportedRF)) == -1) {
                        tooManyCrystals = true;
                        continue;
                    }
                    if (maxSupportedRF != -2) continue;
                    tooMuchPower = true;
                }
            }
        }
        if (!newCrystals.equals(this.crystals)) {
            this.crystals = newCrystals;
            this.setChanged();
        }
        if (this.lasersActive && (tooManyCrystals || tooMuchPower)) {
            if (tooManyCrystals) {
                Broadcaster.broadcast((Level)this.getLevel(), (int)xCoord, (int)yCoord, (int)zCoord, (String)"There are too many crystals for this size generator!", (float)100.0f);
            }
            if (tooMuchPower) {
                Broadcaster.broadcast((Level)this.getLevel(), (int)xCoord, (int)yCoord, (int)zCoord, (String)"Some crystals are too powerful for this size generator!!", (float)100.0f);
            }
        }
    }

    public void addCrystal(int x, int y, int z) {
        if (this.blobId == -1) {
            return;
        }
        DRGeneratorNetwork channels = DRGeneratorNetwork.getNetwork(this.level);
        GeneratorBlob blob = channels.getBlob(this.blobId);
        if (blob == null) {
            return;
        }
        int maxSupportedRF = blob.getGeneratorBlocks() * (Integer)GeneratorConfig.MAX_POWER_INPUT_PER_BLOCK.get();
        for (BlockPos coordinate : this.crystals) {
            ResonatingCrystalTileEntity crystal;
            BlockEntity te = this.level.getBlockEntity(new BlockPos(this.getBlockPos().getX() + coordinate.getX(), this.getBlockPos().getY() + coordinate.getY(), this.getBlockPos().getZ() + coordinate.getZ()));
            if (!(te instanceof ResonatingCrystalTileEntity) || !((crystal = (ResonatingCrystalTileEntity)te).getPower() > (double)1.0E-5f)) continue;
            maxSupportedRF -= crystal.getRfPerTick();
        }
        if (this.addCrystal(x, y, z, blob, this.crystals, this.crystals, maxSupportedRF) >= 0) {
            this.setChanged();
        }
    }

    private int addCrystal(int x, int y, int z, GeneratorBlob network, Set<BlockPos> newCrystals, Set<BlockPos> oldCrystals, int maxSupportedRF) {
        int maxSupportedCrystals = network.getGeneratorBlocks() * (Integer)GeneratorConfig.MAX_CRYSTALS_PER_BLOCK.get();
        BlockEntity te = this.level.getBlockEntity(new BlockPos(x, y, z));
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            if (crystal.getPower() > (double)1.0E-5f) {
                BlockPos crystalCoordinate = new BlockPos(x - this.getBlockPos().getX(), y - this.getBlockPos().getY(), z - this.getBlockPos().getZ());
                if (crystal.isGlowing() && !oldCrystals.contains(crystalCoordinate)) {
                    return maxSupportedRF;
                }
                if (newCrystals.size() >= maxSupportedCrystals) {
                    crystal.setGlowing(false);
                    return -1;
                }
                if (crystal.getRfPerTick() > maxSupportedRF) {
                    crystal.setGlowing(false);
                    return -2;
                }
                maxSupportedRF -= crystal.getRfPerTick();
                newCrystals.add(crystalCoordinate);
                crystal.setGlowing(this.lasersActive);
            } else {
                crystal.setGlowing(false);
            }
        }
        return maxSupportedRF;
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        this.saveClientDataToNBT(tagCompound, provider);
        tagCompound.putInt("networkId", this.blobId);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.loadClientDataFromNBT(tagCompound, provider);
        this.blobId = tagCompound.contains("networkId") ? tagCompound.getInt("networkId") : -1;
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.lasersActive = tagCompound.getBoolean("lasersActive");
        this.laserStartup = tagCompound.getInt("laserStartup");
        byte[] crystalX = tagCompound.getByteArray("crystalsX");
        byte[] crystalY = tagCompound.getByteArray("crystalsY");
        byte[] crystalZ = tagCompound.getByteArray("crystalsZ");
        this.crystals.clear();
        for (int i = 0; i < crystalX.length; ++i) {
            this.crystals.add(new BlockPos((int)crystalX[i], (int)crystalY[i], (int)crystalZ[i]));
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        byte[] crystalX = new byte[this.crystals.size()];
        byte[] crystalY = new byte[this.crystals.size()];
        byte[] crystalZ = new byte[this.crystals.size()];
        int i = 0;
        for (BlockPos crystal : this.crystals) {
            crystalX[i] = (byte)crystal.getX();
            crystalY[i] = (byte)crystal.getY();
            crystalZ[i] = (byte)crystal.getZ();
            ++i;
        }
        tagCompound.putByteArray("crystalsX", crystalX);
        tagCompound.putByteArray("crystalsY", crystalY);
        tagCompound.putByteArray("crystalsZ", crystalZ);
        tagCompound.putBoolean("lasersActive", this.lasersActive);
        tagCompound.putInt("laserStartup", this.laserStartup);
    }

    public Set<BlockPos> getCrystals() {
        return this.crystals;
    }
}

