/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.data.DRGeneratorNetwork;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.sound.GeneratorSoundController;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GeneratorControllerTileEntity
extends TickingTileEntity {
    private int startup = 0;
    private int shutdown = 0;
    private boolean active = false;
    private PlayingSound clientSound = PlayingSound.NONE;

    public GeneratorControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GeneratorModule.TYPE_GENERATOR_CONTROLLER.get(), pos, state);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        boolean working = this.isPowered();
        super.onDataPacket(net, packet, provider);
        if (this.level.isClientSide && this.isPowered() != working) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide) {
            this.stopSounds();
        }
    }

    protected void tickServer() {
        PlayingSound newsound;
        boolean active1 = this.powerLevel > 0;
        boolean dirty = false;
        HashSet<Integer> networks = new HashSet<Integer>();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            GeneratorPartTileEntity generatorTileEntity;
            int networkId;
            BlockPos newC = this.getBlockPos().relative(direction);
            Block b = this.level.getBlockState(newC).getBlock();
            if (b != GeneratorModule.GENERATOR_PART.block().get() || (networkId = (generatorTileEntity = (GeneratorPartTileEntity)this.level.getBlockEntity(newC)).getMultiblockId()) == -1 || networks.contains(networkId)) continue;
            networks.add(networkId);
            if (active1) {
                int countCollectors = this.getCollectorBlocks(generatorTileEntity.getMultiblockId(), generatorTileEntity.getBlob(), newC);
                if (countCollectors == 1) {
                    if (!this.handleActivate(networkId, newC)) continue;
                    dirty = true;
                    continue;
                }
                if (countCollectors < 1) {
                    Broadcaster.broadcast((Level)this.level, (int)this.getBlockPos().getX(), (int)this.getBlockPos().getY(), (int)this.getBlockPos().getZ(), (String)"There is no energy collector on this generator!", (float)100.0f);
                } else {
                    Broadcaster.broadcast((Level)this.level, (int)this.getBlockPos().getX(), (int)this.getBlockPos().getY(), (int)this.getBlockPos().getZ(), (String)"There are too many energy collectors on this generator!!", (float)100.0f);
                }
                if (!this.handleDeactivate(networkId, newC)) continue;
                dirty = true;
                continue;
            }
            if (!this.handleDeactivate(networkId, newC)) continue;
            dirty = true;
        }
        if (networks.isEmpty()) {
            this.shutdown = 0;
        }
        if (dirty) {
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.level);
            generatorNetwork.save();
        }
        if ((newsound = this.getPlayingSound()) != this.clientSound) {
            this.clientSound = newsound;
            this.markDirtyClient();
        }
    }

    protected void tickClient() {
        if ((Double)GeneratorConfig.BASE_GENERATOR_VOLUME.get() < (double)0.01f) {
            return;
        }
        switch (this.clientSound.ordinal()) {
            case 0: {
                this.stopSounds();
                break;
            }
            case 1: {
                if (GeneratorSoundController.isStartupPlaying(this.level, this.worldPosition)) break;
                GeneratorSoundController.playStartup(this.level, this.worldPosition);
                break;
            }
            case 2: {
                if (GeneratorSoundController.isLoopPlaying(this.level, this.worldPosition)) break;
                GeneratorSoundController.playLoop(this.level, this.worldPosition);
                break;
            }
            case 3: {
                if (GeneratorSoundController.isShutdownPlaying(this.level, this.worldPosition)) break;
                GeneratorSoundController.playShutdown(this.level, this.worldPosition);
            }
        }
    }

    private PlayingSound getPlayingSound() {
        if (this.startup != 0) {
            return PlayingSound.STARTUP;
        }
        if (this.shutdown != 0) {
            return PlayingSound.SHUTDOWN;
        }
        if (this.active) {
            return PlayingSound.ACTIVE;
        }
        return PlayingSound.NONE;
    }

    private void stopSounds() {
        GeneratorSoundController.stopSound(this.level, this.getBlockPos());
    }

    private MultiblockDriver<GeneratorBlob> getDriver() {
        return DRGeneratorNetwork.getNetwork(this.level).getDriver();
    }

    private int getCollectorBlocks(int id, GeneratorBlob network, BlockPos p) {
        if (network.getCollectorBlocks() <= 0) {
            Set positions = MultiblockSupport.findMultiblock((Level)this.level, (BlockPos)p, this.getDriver());
            int cnt = 0;
            for (BlockPos pos : positions) {
                if (!(this.level.getBlockEntity(pos.above()) instanceof EnergyCollectorTileEntity)) continue;
                ++cnt;
            }
            int finalCnt = cnt;
            this.getDriver().modify(id, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(finalCnt));
        }
        return network.getCollectorBlocks();
    }

    private boolean handleActivate(int id, BlockPos coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.level);
        GeneratorBlob network = generatorNetwork.getOrCreateBlob(id);
        if (network.isActive() && network.getShutdownCounter() == 0) {
            return false;
        }
        this.startup = network.getStartupCounter();
        if (this.startup == 0) {
            this.startup = (Integer)GeneratorConfig.STARTUP_TIME.get();
        }
        --this.startup;
        if (this.startup <= 0) {
            this.startup = 0;
            GeneratorPartTileEntity generatorTileEntity = (GeneratorPartTileEntity)this.level.getBlockEntity(coordinate);
            generatorTileEntity.activate(true);
        }
        this.active = network.isActive();
        this.shutdown = 0;
        network.setShutdownCounter(0);
        network.setStartupCounter(this.startup);
        this.setChanged();
        return true;
    }

    private boolean handleDeactivate(int id, BlockPos coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.level);
        GeneratorBlob network = generatorNetwork.getOrCreateBlob(id);
        if (!network.isActive() && network.getShutdownCounter() == 0 && network.getStartupCounter() == 0) {
            if (network.getShutdownCounter() != this.shutdown || network.getStartupCounter() != this.startup || network.isActive() != this.active) {
                this.shutdown = network.getShutdownCounter();
                this.startup = network.getStartupCounter();
                this.active = network.isActive();
                this.setChanged();
            }
            return false;
        }
        this.shutdown = network.getShutdownCounter();
        if (network.isActive() || network.getStartupCounter() != 0) {
            this.shutdown = (Integer)GeneratorConfig.SHUTDOWN_TIME.get();
            GeneratorPartTileEntity generatorTileEntity = (GeneratorPartTileEntity)this.level.getBlockEntity(coordinate);
            generatorTileEntity.activate(false);
        }
        --this.shutdown;
        if (this.shutdown <= 0) {
            this.shutdown = 0;
        }
        this.startup = 0;
        this.active = network.isActive();
        network.setStartupCounter(0);
        network.setShutdownCounter(this.shutdown);
        this.setChanged();
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.setChanged();
        }
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putInt("startup", this.startup);
        tagCompound.putInt("shutdown", this.shutdown);
        tagCompound.putBoolean("active", this.active);
        tagCompound.putInt("playingSound", this.clientSound.ordinal());
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.startup = tagCompound.getInt("startup");
        this.shutdown = tagCompound.getInt("shutdown");
        this.active = tagCompound.getBoolean("active");
        this.clientSound = PlayingSound.values()[tagCompound.getInt("playingSound")];
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.putInt("playingSound", this.clientSound.ordinal());
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.clientSound = PlayingSound.values()[tagCompound.getInt("playingSound")];
    }

    static enum PlayingSound {
        NONE,
        STARTUP,
        ACTIVE,
        SHUTDOWN;

    }
}

