/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.deepresonance.compat.DeepResonanceTOPDriver;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.data.GeneratorPartData;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GeneratorPartBlock
extends BaseBlock {
    public GeneratorPartBlock() {
        super(new BlockBuilder().tileEntitySupplier(GeneratorPartTileEntity::new).topDriver((TOPDriver)DeepResonanceTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"power", GeneratorPartBlock::getPowerString)}));
    }

    private static String getPowerString(ItemStack stack) {
        GeneratorPartData data = (GeneratorPartData)stack.getOrDefault(GeneratorModule.ITEM_GENERATOR_PART_DATA, (Object)GeneratorPartData.DEFAULT);
        return data.preservedEnergy() + "FE";
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockState state = super.getStateForPlacement(context);
        Level world = context.getLevel();
        return (BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(world.getBlockState((pos = context.getClickedPos()).above()).getBlock() == this))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(world.getBlockState(pos.below()).getBlock() == this))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)state.setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(facingState.getBlock() == this));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)state.setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(facingState.getBlock() == this));
        }
        return state;
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED, BlockStateProperties.UP, BlockStateProperties.DOWN});
    }
}

