/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.data.DRGeneratorNetwork;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.data.GeneratorPartData;
import mcjty.deepresonance.modules.generator.data.NetworkEnergyStorage;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GeneratorPartTileEntity
extends TickingTileEntity
implements IMultiblockConnector {
    private int blobId = -1;
    private final NetworkEnergyStorage energyStorage = new NetworkEnergyStorage(this);
    @Cap(type=CapType.ENERGY)
    private static final Function<GeneratorPartTileEntity, NetworkEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;

    public GeneratorPartTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GeneratorModule.TYPE_GENERATOR_PART.get(), pos, state);
    }

    public void tickServer() {
        int energyStored = this.energyStorage.getEnergyStored();
        if (energyStored <= 0) {
            return;
        }
        boolean dirty = false;
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            Direction opposite;
            BlockPos pos = this.getBlockPos().relative(facing);
            BlockEntity te = this.level.getBlockEntity(pos);
            if (!EnergyTools.isEnergyTE((BlockEntity)te, (Direction)(opposite = facing.getOpposite()))) continue;
            int rfToGive = Math.min((Integer)GeneratorConfig.POWER_PER_TICKOUT.get(), energyStored);
            int received = (int)EnergyTools.receiveEnergy((BlockEntity)te, (Direction)opposite, (long)rfToGive);
            if (received > 0) {
                dirty = true;
                energyStored -= this.energyStorage.consumeEnergy(received);
            }
            if (energyStored <= 0) break;
        }
        if (dirty) {
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.level);
            generatorNetwork.setDirty();
        }
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.isClientSide()) {
            GeneratorPartData data;
            int energy;
            this.addBlockToNetwork();
            GeneratorBlob network = this.getBlob();
            if (network != null && (energy = (data = (GeneratorPartData)stack.getOrDefault(GeneratorModule.ITEM_GENERATOR_PART_DATA, (Object)GeneratorPartData.DEFAULT)).preservedEnergy()) > 0) {
                this.getDriver().modify(this.getMultiblockId(), holder -> ((GeneratorBlob)holder.getMb()).setEnergy(((GeneratorBlob)holder.getMb()).getEnergy() + energy));
            }
        }
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (!world.isClientSide()) {
            BlockState stateDown;
            BlockState stateUp;
            if (newstate.getBlock() != GeneratorModule.GENERATOR_PART.block().get()) {
                GeneratorBlob network = this.getBlob();
                if (network != null) {
                    int generatorBlocks = network.getGeneratorBlocks();
                    int energy = generatorBlocks == 0 ? 0 : network.getEnergy() / generatorBlocks;
                    network.setEnergy(network.getEnergy() - energy);
                    this.setData((Supplier)GeneratorModule.GENERATOR_PART_DATA, new GeneratorPartData(energy));
                } else {
                    this.setData((Supplier)GeneratorModule.GENERATOR_PART_DATA, new GeneratorPartData(0));
                }
                this.setChanged();
                this.removeBlockFromNetwork();
            }
            if ((stateUp = world.getBlockState(pos.above())).getBlock() == GeneratorModule.GENERATOR_PART.block().get()) {
                world.sendBlockUpdated(pos.above(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.getBlockState(pos.below())).getBlock() == GeneratorModule.GENERATOR_PART.block().get()) {
                world.sendBlockUpdated(pos.below(), stateDown, stateDown, 3);
            }
        }
    }

    public void addBlockToNetwork() {
        GeneratorBlob newMb = new GeneratorBlob().setGeneratorBlocks(1).setActive(false);
        MultiblockSupport.addBlock((Level)this.level, (BlockPos)this.getBlockPos(), DRGeneratorNetwork.getNetwork(this.level).getDriver(), (IMultiblock)newMb);
    }

    public void removeBlockFromNetwork() {
        MultiblockSupport.removeBlock((Level)this.level, (BlockPos)this.getBlockPos(), DRGeneratorNetwork.getNetwork(this.level).getDriver());
    }

    public void setMultiblockId(int newId) {
        if (this.blobId != newId) {
            this.blobId = newId;
            this.setChanged();
        }
    }

    public ResourceLocation getId() {
        return DRGeneratorNetwork.GENERATOR_NETWORK_ID;
    }

    public int getMultiblockId() {
        return this.blobId;
    }

    private MultiblockDriver<GeneratorBlob> getDriver() {
        return DRGeneratorNetwork.getNetwork(this.level).getDriver();
    }

    public GeneratorBlob getBlob() {
        if (this.blobId == -1) {
            return null;
        }
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.level);
        return generatorNetwork.getOrCreateBlob(this.blobId);
    }

    public void activate(boolean active) {
        GeneratorBlob network = this.getBlob();
        if (network != null && network.isActive() != active) {
            this.getDriver().modify(this.getMultiblockId(), holder -> ((GeneratorBlob)holder.getMb()).setActive(active));
            HashSet done = Sets.newHashSet();
            this.activateBlocks(this.getBlockPos(), done, active);
        }
    }

    private void activateBlocks(BlockPos c, Set<BlockPos> done, boolean active) {
        done.add(c);
        BlockState state = this.level.getBlockState(c);
        if ((Boolean)state.getValue((Property)BlockStateProperties.POWERED) != active) {
            this.level.setBlock(c, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(active)), 3);
        }
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            Block block;
            BlockPos newC = c.relative(direction);
            if (done.contains(newC) || (block = this.level.getBlockState(newC).getBlock()) != GeneratorModule.GENERATOR_PART.block().get()) continue;
            this.activateBlocks(newC, done, active);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.blobId = tag.getInt("networkId");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("networkId", this.blobId);
    }
}

