/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.deepresonance.setup.ClientSetup;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public class CollectorRenderer
implements BlockEntityRenderer<EnergyCollectorTileEntity> {
    private static final RenderSettings SETTINGS = RenderSettings.builder().color(255, 0, 0).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).width(0.1f).alpha(200).build();
    private static final RenderSettings SETTINGS_LASER = RenderSettings.builder().width(0.1f).alpha(128).build();
    public static final Vec3 START = new Vec3(0.5, 0.8, 0.5);
    private final Random random = new Random();

    public CollectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)GeneratorModule.TYPE_ENERGY_COLLECTOR.get()), CollectorRenderer::new);
    }

    public void render(@Nonnull EnergyCollectorTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntity.getCrystals().isEmpty() || !tileEntity.areLasersActive() && tileEntity.getLaserStartup() <= 0) {
            return;
        }
        VertexConsumer buf = buffer.getBuffer(RenderType.TRANSLUCENT);
        this.renderHalo(matrixStack, buf);
        this.renderLasers(tileEntity.getBlockPos(), tileEntity.getLaserStartup(), tileEntity.getCrystals(), matrixStack, buf);
    }

    private void renderHalo(PoseStack matrixStack, VertexConsumer buffer) {
        RenderHelper.renderSplitBillboard((PoseStack)matrixStack, (VertexConsumer)buffer, (float)1.0f, (Vec3)new Vec3(0.0, 0.25, 0.0), (ResourceLocation)ClientSetup.HALO);
    }

    private void renderLasers(BlockPos pos, int laserStartup, Set<BlockPos> crystals, PoseStack matrixStack, VertexConsumer builder) {
        double startupFactor = (double)laserStartup / (double)((Integer)GeneratorConfig.STARTUP_TIME.get()).intValue();
        for (BlockPos destination : crystals) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ClientSetup.LASERBEAMS[this.random.nextInt(4)]);
            int tex = pos.getX();
            int tey = pos.getY();
            int tez = pos.getZ();
            Vec3 player = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().add((double)(-tex), (double)(-tey), (double)(-tez));
            Vec3 end = new Vec3((double)destination.getX() + 0.5, (double)destination.getY() + 0.5, (double)destination.getZ() + 0.5);
            if (startupFactor > 0.8) continue;
            if (startupFactor > 0.001) {
                Vec3 middle = new Vec3(this.jitter(startupFactor, START.x(), end.x()), this.jitter(startupFactor, START.y(), end.y()), this.jitter(startupFactor, START.z(), end.z()));
                RenderHelper.drawBeam((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vec3)START, (Vec3)middle, (Vec3)player, (RenderSettings)SETTINGS_LASER);
                RenderHelper.drawBeam((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vec3)middle, (Vec3)end, (Vec3)player, (RenderSettings)SETTINGS_LASER);
                continue;
            }
            RenderHelper.drawBeam((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vec3)START, (Vec3)end, (Vec3)player, (RenderSettings)SETTINGS_LASER);
        }
    }

    private double jitter(double startupFactor, double a1, double a2) {
        return (a1 + a2) / 2.0 + (this.random.nextDouble() * 2.0 - 1.0) * startupFactor;
    }
}

