/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.data;

import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.data.GeneratorFixer;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.IMultiblockFixer;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DRGeneratorNetwork
extends AbstractWorldData<DRGeneratorNetwork> {
    private static final String GENERATOR_NETWORK_NAME = "DRGeneratorNetwork";
    public static final ResourceLocation GENERATOR_NETWORK_ID = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"generator");
    private final MultiblockDriver<GeneratorBlob> driver = MultiblockDriver.builder().loader(GeneratorBlob::load).saver(GeneratorBlob::save).dirtySetter(d -> this.setDirty()).mergeChecker((b1, b2) -> true).fixer((IMultiblockFixer)new GeneratorFixer()).holderGetter((world, blockPos) -> {
        BlockEntity be = world.getBlockEntity(blockPos);
        if (be instanceof IMultiblockConnector && ((IMultiblockConnector)be).getId().equals((Object)GENERATOR_NETWORK_ID)) {
            return (IMultiblockConnector)be;
        }
        return null;
    }).build();

    public DRGeneratorNetwork() {
    }

    public DRGeneratorNetwork(CompoundTag tag) {
        this.driver.load(tag);
    }

    public void clear() {
        this.driver.clear();
    }

    public MultiblockDriver<GeneratorBlob> getDriver() {
        return this.driver;
    }

    public static DRGeneratorNetwork getNetwork(Level world) {
        return (DRGeneratorNetwork)DRGeneratorNetwork.getData((Level)world, DRGeneratorNetwork::new, DRGeneratorNetwork::new, (String)GENERATOR_NETWORK_NAME);
    }

    public GeneratorBlob getBlob(int id) {
        return (GeneratorBlob)this.driver.get(id);
    }

    public GeneratorBlob getOrCreateBlob(int id) {
        GeneratorBlob network = this.getBlob(id);
        if (network == null) {
            network = new GeneratorBlob().setGeneratorBlocks(0).setActive(false);
            this.driver.createOrUpdate(id, (IMultiblock)network);
        }
        return network;
    }

    public void deleteBlob(int id) {
        this.driver.delete(id);
    }

    public int newBlob() {
        return this.driver.createId();
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        return this.driver.save(tagCompound);
    }
}

