/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines;

import java.util.function.Supplier;
import mcjty.deepresonance.datagen.BlockStates;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.DataGenHelper;
import mcjty.deepresonance.modules.machines.block.CrystallizerTileEntity;
import mcjty.deepresonance.modules.machines.block.LaserTileEntity;
import mcjty.deepresonance.modules.machines.block.LensBlock;
import mcjty.deepresonance.modules.machines.block.LensTileEntity;
import mcjty.deepresonance.modules.machines.block.PurifierTileEntity;
import mcjty.deepresonance.modules.machines.block.SmelterTileEntity;
import mcjty.deepresonance.modules.machines.block.ValveTileEntity;
import mcjty.deepresonance.modules.machines.client.CrystallizerGui;
import mcjty.deepresonance.modules.machines.client.CrystallizerRenderer;
import mcjty.deepresonance.modules.machines.client.LaserGui;
import mcjty.deepresonance.modules.machines.client.LaserRenderer;
import mcjty.deepresonance.modules.machines.client.PurifierGui;
import mcjty.deepresonance.modules.machines.client.SmelterGui;
import mcjty.deepresonance.modules.machines.client.ValveGui;
import mcjty.deepresonance.modules.machines.data.CrystalizerData;
import mcjty.deepresonance.modules.machines.data.InfusionBonusRegistry;
import mcjty.deepresonance.modules.machines.data.LaserData;
import mcjty.deepresonance.modules.machines.data.ValveData;
import mcjty.deepresonance.modules.machines.item.ItemLens;
import mcjty.deepresonance.modules.machines.util.config.CrystallizerConfig;
import mcjty.deepresonance.modules.machines.util.config.LaserConfig;
import mcjty.deepresonance.modules.machines.util.config.PurifierConfig;
import mcjty.deepresonance.modules.machines.util.config.SmelterConfig;
import mcjty.deepresonance.modules.machines.util.config.ValveConfig;
import mcjty.deepresonance.setup.Registration;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MachinesModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, ValveTileEntity> VALVE = Registration.registerBlockWithTile("valve", ValveTileEntity.class, ValveTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), ValveTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ValveTileEntity>> TYPE_VALVE = VALVE.be();
    public static final Supplier<MenuType<GenericContainer>> VALVE_CONTAINER = Registration.CONTAINERS.register("valve", GenericContainer::createContainerType);
    public static final RBlock<BaseBlock, BlockItem, SmelterTileEntity> SMELTER = Registration.registerBlockWithTile("smelter", SmelterTileEntity.class, SmelterTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), SmelterTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<SmelterTileEntity>> TYPE_SMELTER = SMELTER.be();
    public static final Supplier<MenuType<GenericContainer>> SMELTER_CONTAINER = Registration.CONTAINERS.register("smelter", GenericContainer::createContainerType);
    public static final RBlock<BaseBlock, BlockItem, PurifierTileEntity> PURIFIER = Registration.registerBlockWithTile("purifier", PurifierTileEntity.class, PurifierTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), PurifierTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PurifierTileEntity>> TYPE_PURIFIER = PURIFIER.be();
    public static final Supplier<MenuType<GenericContainer>> PURIFIER_CONTAINER = Registration.CONTAINERS.register("purifier", GenericContainer::createContainerType);
    public static final RBlock<LensBlock, ItemLens, LensTileEntity> LENS = Registration.registerBlockWithTile("lens", LensTileEntity.class, LensBlock::new, block -> new ItemLens((LensBlock)((Object)((Object)block.get())), Registration.createStandardProperties()), LensTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<LensTileEntity>> TYPE_LENS = LENS.be();
    public static final RBlock<BaseBlock, BlockItem, LaserTileEntity> LASER = Registration.registerBlockWithTile("laser", LaserTileEntity.class, LaserTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), LaserTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<LaserTileEntity>> TYPE_LASER = LASER.be();
    public static final Supplier<MenuType<GenericContainer>> LASER_CONTAINER = Registration.CONTAINERS.register("laser", GenericContainer::createContainerType);
    public static final RBlock<BaseBlock, BlockItem, CrystallizerTileEntity> CRYSTALLIZER = Registration.registerBlockWithTile("crystallizer", CrystallizerTileEntity.class, CrystallizerTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), CrystallizerTileEntity::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<CrystallizerTileEntity>> TYPE_CRYSTALIZER = CRYSTALLIZER.be();
    public static final Supplier<MenuType<GenericContainer>> CRYSTALIZER_CONTAINER = Registration.CONTAINERS.register("crystallizer", GenericContainer::createContainerType);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CrystalizerData>> ITEM_CRYSTALIZER_DATA = Registration.COMPONENTS.registerComponentType("crystalizer", builder -> builder.persistent(CrystalizerData.CODEC).networkSynchronized(CrystalizerData.STREAM_CODEC));
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<LaserData>> LASER_DATA = Registration.ATTACHMENT_TYPES.register("laser", () -> AttachmentType.builder(() -> LaserData.DEFAULT).serialize(LaserData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<LaserData>> ITEM_LASER_DATA = Registration.COMPONENTS.registerComponentType("laser", builder -> builder.persistent(LaserData.CODEC).networkSynchronized(LaserData.STREAM_CODEC));
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<ValveData>> VALVE_DATA = Registration.ATTACHMENT_TYPES.register("valve", () -> AttachmentType.builder(() -> ValveData.DEFAULT).serialize(ValveData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ValveData>> ITEM_VALVE_DATA = Registration.COMPONENTS.registerComponentType("valve", builder -> builder.persistent(ValveData.CODEC).networkSynchronized(ValveData.STREAM_CODEC));

    public MachinesModule(IEventBus bus) {
        bus.addListener(this::registerMenuScreens);
    }

    public void initClient(FMLClientSetupEvent event) {
        CrystallizerRenderer.register();
        LaserRenderer.register();
    }

    public void registerMenuScreens(RegisterMenuScreensEvent event) {
        SmelterGui.register(event);
        LaserGui.register(event);
        PurifierGui.register(event);
        CrystallizerGui.register(event);
        ValveGui.register(event);
    }

    public void init(FMLCommonSetupEvent event) {
        InfusionBonusRegistry.createDefaultInfusionBonusMap();
    }

    public void initConfig(IEventBus bus) {
        CrystallizerConfig.init();
        LaserConfig.init();
        PurifierConfig.init();
        SmelterConfig.init();
        ValveConfig.init();
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider lookupProvider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(VALVE).ironPickaxeTags().parentedItem().standardLoot(new DataComponentType[]{(DataComponentType)ITEM_VALVE_DATA.get()}).blockState(provider -> provider.simpleBlock((Block)VALVE.block().get(), (ModelFile)provider.models().cubeBottomTop(provider.name((Block)VALVE.block().get()), ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/valve"), BlockStates.DEFAULT_BOTTOM, BlockStates.DEFAULT_TOP))).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)CoreModule.FILTER_MATERIAL_ITEM.get()).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"GGG", "FmF", "GCG"}), Dob.blockBuilder(SMELTER).ironPickaxeTags().parentedItem().standardLoot(new DataComponentType[0]).blockState(provider -> provider.horizontalOrientedBlock((Block)SMELTER.block().get(), (state, builder) -> {
            if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
                builder.modelFile(provider.frontBasedModel(provider.name(state.getBlock()) + "_active", ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/smelter_active"), BlockStates.DEFAULT_SIDE, BlockStates.DEFAULT_TOP, BlockStates.DEFAULT_BOTTOM));
            } else {
                builder.modelFile(provider.frontBasedModel(provider.name(state.getBlock()), ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/smelter"), BlockStates.DEFAULT_SIDE, BlockStates.DEFAULT_TOP, BlockStates.DEFAULT_BOTTOM));
            }
        })).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)CoreModule.FILTER_MATERIAL_ITEM.get()).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"FFF", "imi", "FFF"}), Dob.blockBuilder(PURIFIER).ironPickaxeTags().parentedItem().standardLoot(new DataComponentType[0]).blockState(provider -> provider.horizontalOrientedBlock((Block)PURIFIER.block().get(), (state, builder) -> builder.modelFile(provider.frontBasedModel(provider.name(state.getBlock()), ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/purifier"), BlockStates.DEFAULT_SIDE, BlockStates.DEFAULT_TOP, BlockStates.DEFAULT_BOTTOM)))).shaped(builder -> builder.define(Character.valueOf('P'), (ItemLike)CoreModule.RESONATING_PLATE_ITEM.get()).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).define(Character.valueOf('x'), (ItemLike)Items.NETHER_BRICK).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"PPP", "imi", "xxx"}), Dob.blockBuilder(LENS).ironPickaxeTags().simpleLoot().parentedItem("block/lens_mc").blockState(provider -> provider.horizontalOrientedBlock((Block)LENS.block().get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent("lens_mc", ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"lens"))).texture("lens_texture", "deepresonance:block/lens")).texture("particle", "deepresonance:block/lens"))).shaped(builder -> builder.define(Character.valueOf('g'), Tags.Items.GLASS_PANES).define(Character.valueOf('P'), (ItemLike)CoreModule.RESONATING_PLATE_ITEM.get()).unlockedBy("has_pane", DataGen.has((TagKey)Tags.Items.GLASS_PANES)), new String[]{"gPg", "P P", "gPg"}), Dob.blockBuilder(LASER).ironPickaxeTags().parentedItem().standardLoot(new DataComponentType[]{(DataComponentType)ITEM_LASER_DATA.get()}).blockState(provider -> provider.horizontalOrientedBlock((Block)LASER.block().get(), (ModelFile)DataGenHelper.createLaserModel(provider))).shaped(builder -> builder.define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).define(Character.valueOf('X'), Tags.Items.INGOTS_GOLD).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"GXG", "eme", "ddd"}), Dob.blockBuilder(CRYSTALLIZER).ironPickaxeTags().parentedItem().standardLoot(new DataComponentType[]{(DataComponentType)ITEM_CRYSTALIZER_DATA.get(), (DataComponentType)CoreModule.ITEM_LCD_DATA.get()}).blockState(provider -> provider.horizontalBlock((Block)CRYSTALLIZER.block().get(), (ModelFile)DataGenHelper.createCrystallizerModel(provider))).shaped(builder -> builder.define(Character.valueOf('q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('m'), (ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()).define(Character.valueOf('X'), Tags.Items.INGOTS_GOLD).unlockedBy("has_machine_frame", DataGen.has((ItemLike)((ItemLike)CoreModule.MACHINE_FRAME_ITEM.get()))), new String[]{"GXG", "qmq", "iii"})});
    }
}

