/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.core.data.LCD;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.data.CrystalizerData;
import mcjty.deepresonance.modules.machines.util.config.CrystallizerConfig;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CrystallizerTileEntity
extends TickingTileEntity {
    public static final int SLOT = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.generic().out(), 0, 64, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((integer, stack) -> stack.getItem() == CoreModule.RESONATING_CRYSTAL_GENERATED.item().get()).insertable(GenericItemHandler.no()).extractable(GenericItemHandler.yes()).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<CrystallizerTileEntity, GenericItemHandler> ITEMS_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)CrystallizerConfig.POWER_MAXIMUM.get()).intValue(), (long)((Integer)CrystallizerConfig.POWER_PER_TICK_IN.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<CrystallizerTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<CrystallizerTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Crystalizer").containerSupplier(DefaultContainerProvider.container(MachinesModule.CRYSTALIZER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);
    private int progress;
    private LiquidCrystalData crystalData;
    private IFluidHandler rclTank;
    private int tankCooldown = 0;

    public CrystallizerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_CRYSTALIZER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(CrystallizerTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    public void tickServer() {
        int newProgress;
        if (!this.canCrystallize()) {
            return;
        }
        int oldProgress = this.crystalData == null ? 0 : (int)((float)this.crystalData.getAmount() / (float)CrystallizerTileEntity.getRclPerCrystal() * 100.0f);
        this.energyStorage.consumeEnergy((long)((Integer)CrystallizerConfig.POWER_PER_TICK.get()).intValue());
        int rclPerCrystal = CrystallizerTileEntity.getRclPerCrystal();
        int drain = (Integer)CrystallizerConfig.RCL_PER_TICK.get();
        if (this.crystalData != null) {
            drain = Math.min(drain, rclPerCrystal - this.crystalData.getAmount());
        }
        if (drain > 0) {
            FluidStack stack = this.rclTank.drain(drain, IFluidHandler.FluidAction.EXECUTE);
            LiquidCrystalData data = LiquidCrystalData.fromStack(stack);
            if (this.crystalData == null) {
                this.crystalData = data;
            } else {
                this.crystalData.merge(data);
            }
        }
        if (this.crystalData != null && this.crystalData.getAmount() >= rclPerCrystal) {
            ResonatingCrystalTileEntity crystal = new ResonatingCrystalTileEntity(this.worldPosition, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.block().get())).defaultBlockState());
            crystal.setEfficiency(this.crystalData.getEfficiency() * 100.0);
            crystal.setPurity(this.crystalData.getPurity() * 100.0);
            crystal.setStrength(this.crystalData.getStrength() * 100.0);
            crystal.setPower(100.0);
            this.crystalData = null;
            this.items.setStackInSlot(0, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.block().get())).createStack(crystal));
            this.setChanged();
        }
        int n = newProgress = this.crystalData == null ? 0 : (int)((float)this.crystalData.getAmount() / (float)CrystallizerTileEntity.getRclPerCrystal() * 100.0f);
        if (oldProgress != newProgress) {
            this.markDirtyClient();
        }
    }

    public int getMaxPower() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getCurrentPower() {
        return this.energyStorage.getEnergyStored();
    }

    private boolean canCrystallize() {
        if (this.tankCooldown > 0) {
            --this.tankCooldown;
        }
        if (this.rclTank == null && !this.checkTank()) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() < (Integer)CrystallizerConfig.POWER_PER_TICK.get()) {
            return false;
        }
        if (this.hasCrystal()) {
            return false;
        }
        FluidStack fluidStack = this.rclTank.drain(((Integer)CrystallizerConfig.RCL_PER_TICK.get()).intValue(), IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty() || fluidStack.getAmount() < 1) {
            return false;
        }
        return LiquidCrystalData.isValidLiquidCrystalStack(fluidStack);
    }

    private boolean checkTank() {
        this.rclTank = null;
        if (this.tankCooldown <= 0) {
            this.tankCooldown = 21;
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.below());
            if (tile != null) {
                this.rclTank = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.below(), null);
                return this.rclTank != null;
            }
        }
        return false;
    }

    public boolean hasCrystal() {
        return !this.items.getStackInSlot(0).isEmpty();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("amount") && tag.contains("lcd")) {
            int amount = tag.getInt("amount");
            LCD lcd = (LCD)LCD.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("lcd")).result().orElseThrow(() -> new IllegalStateException("Invalid LCD"));
            FluidStack stack = LiquidCrystalData.makeLiquidCrystalStack(amount, lcd);
            this.crystalData = LiquidCrystalData.fromStack(stack);
        }
        this.energyStorage.load(tag, "energy", provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.crystalData != null) {
            tag.putInt("amount", this.crystalData.getAmount());
            LCD lcd = this.crystalData.getLCD();
            tag.put("lcd", (Tag)LCD.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)lcd).result().orElseThrow(() -> new IllegalStateException("Invalid LCD")));
        }
        this.energyStorage.save(tag, "energy", provider);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.progress = tagCompound.getInt("progress");
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.progress = this.crystalData == null ? 0 : (int)((float)this.crystalData.getAmount() / (float)CrystallizerTileEntity.getRclPerCrystal() * 100.0f);
        tagCompound.putInt("progress", this.progress);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.crystalData != null) {
            components.set(MachinesModule.ITEM_CRYSTALIZER_DATA, (Object)new CrystalizerData(this.crystalData.getAmount()));
            components.set(CoreModule.ITEM_LCD_DATA, (Object)this.crystalData.getLCD());
        }
        this.energyStorage.collectImplicitComponents(components);
        this.items.collectImplicitComponents(components);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        CrystalizerData cdata = (CrystalizerData)input.get(MachinesModule.ITEM_CRYSTALIZER_DATA);
        LCD lcd = (LCD)input.get(CoreModule.ITEM_LCD_DATA);
        if (cdata != null && lcd != null) {
            FluidStack stack = LiquidCrystalData.makeLiquidCrystalStack(cdata.amount(), lcd);
            this.crystalData = LiquidCrystalData.fromStack(stack);
        }
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    private static int getRclPerCrystal() {
        return (Integer)CrystallizerConfig.RCL_PER_CRYSTAL.get();
    }

    public int getProgress() {
        return this.progress;
    }
}

