/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.data.Crystal;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.LaserContainer;
import mcjty.deepresonance.modules.machines.block.LensBlock;
import mcjty.deepresonance.modules.machines.data.InfusingBonus;
import mcjty.deepresonance.modules.machines.data.InfusionBonusRegistry;
import mcjty.deepresonance.modules.machines.data.LaserData;
import mcjty.deepresonance.modules.machines.util.config.LaserConfig;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LaserTileEntity
extends TickingTileEntity {
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)3);
    public static final int SLOT_CRYSTAL = 0;
    public static final int SLOT_CATALYST = 1;
    private static final int SLOT_ACTIVE_CATALYST = 2;
    private int tickCounter = 10;
    private int progressCounter = 0;
    @GuiValue
    public static final Value<?, Float> VALUE_LIQUID = Value.create((String)"crystalLiquid", (Type)Type.FLOAT, LaserTileEntity::getCrystalLiquid, LaserTileEntity::setCrystalLiquid);
    private int color = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.generic().in().out(), 0, 154, 48).slot(SlotDefinition.generic().in().out(), 1, 21, 8).slot(SlotDefinition.generic().out(), 2, 21, 48).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0) {
            return LaserTileEntity.isCrystalItem(stack.getItem());
        }
        if (slot == 1) {
            return !LaserTileEntity.isCrystalItem(stack.getItem());
        }
        return false;
    }).insertable(GenericItemHandler.notslot((int)2)).extractable(GenericItemHandler.yes()).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<LaserTileEntity, GenericItemHandler> ITEMS_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)LaserConfig.POWER_MAXIMUM.get()).intValue(), (long)((Integer)LaserConfig.POWER_PER_TICK_IN.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<LaserTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<LaserTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Laser").containerSupplier((windowId, player) -> new LaserContainer(MachinesModule.LASER_CONTAINER, (int)windowId, (Supplier<ContainerFactory>)CONTAINER_FACTORY, (GenericTileEntity)be, (Player)player)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);

    public LaserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_LASER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(LaserTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{COLOR});
            }
        };
    }

    private static boolean isCrystalItem(Item item) {
        return item == CoreModule.RESONATING_CRYSTAL_GENERATED.item().get() || item == CoreModule.RESONATING_CRYSTAL_GENERATED_EMPTY.item().get() || item == CoreModule.RESONATING_CRYSTAL_NATURAL.item().get() || item == CoreModule.RESONATING_CRYSTAL_NATURAL_EMPTY.item().get();
    }

    protected void tickServer() {
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 10;
        this.checkCrystal();
        if (this.powerLevel == 0) {
            this.changeColor(0);
            return;
        }
        ItemStack stack = this.items.getStackInSlot(1);
        InfusingBonus bonus = LaserTileEntity.getInfusingBonus(stack);
        if (bonus == null) {
            this.changeColor(0);
            return;
        }
        if (this.getCurrentPower() < (Integer)LaserConfig.RFUSE_PER_CATALYST.get()) {
            this.changeColor(0);
            return;
        }
        LaserData data = (LaserData)this.getData((Supplier)MachinesModule.LASER_DATA);
        if (data.crystalLiquid() < (float)((Integer)LaserConfig.CRYSTAL_LIQUID_PER_CATALYST.get()).intValue()) {
            this.changeColor(0);
            return;
        }
        BlockPos tankCoordinate = this.findLens();
        if (tankCoordinate == null) {
            this.changeColor(0);
            return;
        }
        this.changeColor(bonus.color());
        --this.progressCounter;
        this.setChanged();
        if (this.progressCounter > 0) {
            return;
        }
        this.progressCounter = (Integer)LaserConfig.TICKS10_PER_CATALYST.get();
        this.infuseLiquid(tankCoordinate, bonus);
    }

    public static InfusingBonus getInfusingBonus(ItemStack item) {
        if (item.isEmpty()) {
            return null;
        }
        return InfusionBonusRegistry.getInfusionBonus(item);
    }

    private boolean validRCLTank(TankTileEntity tank) {
        IFluidHandler h = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, tank.getBlockPos(), null);
        if (h == null) {
            return false;
        }
        return LiquidCrystalData.isLiquidCrystal(h.getFluidInTank(0).getFluid());
    }

    private BlockPos findLens() {
        if (!LevelTools.isLoaded((Level)this.level, (BlockPos)this.worldPosition)) {
            return null;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        Direction direction = OrientationTools.getOrientationHoriz((BlockState)state);
        BlockPos shouldBeAir = this.worldPosition.relative(direction);
        if (!this.level.getBlockState(shouldBeAir).isAir()) {
            return null;
        }
        BlockPos shouldBeLens = shouldBeAir.relative(direction);
        Block lensBlock = this.level.getBlockState(shouldBeLens).getBlock();
        if (!(lensBlock instanceof LensBlock)) {
            return null;
        }
        Direction lensDirection = OrientationTools.getOrientationHoriz((BlockState)this.level.getBlockState(shouldBeLens));
        if (lensDirection != direction) {
            return null;
        }
        return shouldBeLens.relative(direction);
    }

    private void infuseLiquid(BlockPos tankCoordinate, InfusingBonus bonus) {
        FluidStack stack;
        IFluidHandler handler;
        TankTileEntity tank;
        this.items.decrStackSize(1, 1);
        this.energyStorage.consumeEnergy((long)((Integer)LaserConfig.RFUSE_PER_CATALYST.get()).intValue());
        LaserData data = (LaserData)this.getData((Supplier)MachinesModule.LASER_DATA);
        float crystalLiquid = data.crystalLiquid();
        this.setData((Supplier)MachinesModule.LASER_DATA, data.withCrystalLiquid(crystalLiquid -= (float)((Integer)LaserConfig.CRYSTAL_LIQUID_PER_CATALYST.get()).intValue()));
        BlockEntity te = this.level.getBlockEntity(tankCoordinate);
        if (te instanceof TankTileEntity && this.validRCLTank(tank = (TankTileEntity)te) && (handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, tank.getBlockPos(), null)) != null && !(stack = handler.drain(10000, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            stack = handler.drain(10000, IFluidHandler.FluidAction.EXECUTE);
            LiquidCrystalData fluidData = LiquidCrystalData.fromStack(stack);
            float factor = (float)((Integer)LaserConfig.RCL_PER_CATALYST.get()).intValue() / (float)stack.getAmount();
            float purity = bonus.purityModifier().modify(fluidData.getPurity(), fluidData.getQuality(), (double)factor);
            float strength = bonus.strengthModifier().modify(fluidData.getStrength(), fluidData.getQuality(), (double)factor);
            float efficiency = bonus.efficiencyModifier().modify(fluidData.getEfficiency(), fluidData.getQuality(), (double)factor);
            fluidData.setPurity(purity);
            fluidData.setStrength(strength);
            fluidData.setEfficiency(efficiency);
            FluidStack newStack = fluidData.getFluidStack();
            if ((double)Math.abs(purity) < 0.01) {
                newStack.setAmount(newStack.getAmount() - 200);
                if (newStack.getAmount() < 0) {
                    newStack.setAmount(0);
                }
            }
            if (newStack.getAmount() > 0) {
                handler.fill(newStack, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private void changeColor(int newcolor) {
        if (newcolor != this.color) {
            int mcolor = this.color = newcolor;
            if (this.color == 4) {
                mcolor = 2;
            } else if (this.color == 0) {
                mcolor = 0;
            }
            this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)COLOR, (Comparable)Integer.valueOf(mcolor)), 3);
            this.setChanged();
        }
    }

    public int getColor() {
        return this.color;
    }

    private void checkCrystal() {
        ItemStack stack = this.items.getStackInSlot(0);
        if (!stack.isEmpty()) {
            Crystal crystal = (Crystal)stack.getOrDefault(CoreModule.ITEM_CRYSTAL_DATA, (Object)Crystal.ZERO);
            double strength = crystal.strength() / 100.0;
            LaserData data = (LaserData)this.getData((Supplier)MachinesModule.LASER_DATA);
            int toAdd = (int)((double)((Integer)LaserConfig.MIN_CRYSTAL_LIQUID_PER_CRYSTAL.get()).intValue() + strength * (double)((Integer)LaserConfig.MAX_CRYSTAL_LIQUID_PER_CRYSTAL.get() - (Integer)LaserConfig.MIN_CRYSTAL_LIQUID_PER_CRYSTAL.get()));
            float amt = data.crystalLiquid() + (float)toAdd;
            if (amt > (float)((Integer)LaserConfig.CRYSTAL_LIQUID_MAXIMUM.get()).intValue()) {
                return;
            }
            stack.shrink(1);
            this.setData((Supplier)MachinesModule.LASER_DATA, data.withCrystalLiquid(amt));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.progressCounter = tag.getInt("progress");
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("progress", this.progressCounter);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        LaserData laserData = (LaserData)input.get(MachinesModule.ITEM_LASER_DATA);
        if (laserData != null) {
            this.setData((Supplier)MachinesModule.LASER_DATA, laserData);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        builder.set(MachinesModule.ITEM_LASER_DATA, (Object)((LaserData)this.getData((Supplier)MachinesModule.LASER_DATA)));
    }

    public int getMaxPower() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getCurrentPower() {
        return this.energyStorage.getEnergyStored();
    }

    public float getCrystalLiquid() {
        LaserData data = (LaserData)this.getData((Supplier)MachinesModule.LASER_DATA);
        return data.crystalLiquid();
    }

    public void setCrystalLiquid(float v) {
        LaserData data = (LaserData)this.getData((Supplier)MachinesModule.LASER_DATA);
        this.setData((Supplier)MachinesModule.LASER_DATA, data.withCrystalLiquid(v));
    }
}

