/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import javax.annotation.Nullable;
import mcjty.deepresonance.modules.machines.block.LensTileEntity;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LensBlock
extends BaseBlock {
    private static final VoxelShape SHAPE_SOUTH = Shapes.box((double)0.2, (double)0.2, (double)0.9, (double)0.8, (double)0.8, (double)1.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.box((double)0.2, (double)0.2, (double)0.0, (double)0.8, (double)0.8, (double)0.1);
    private static final VoxelShape SHAPE_EAST = Shapes.box((double)0.9, (double)0.2, (double)0.2, (double)1.0, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_WEST = Shapes.box((double)0.0, (double)0.2, (double)0.2, (double)0.1, (double)0.8, (double)0.8);

    public LensBlock() {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).noOcclusion().noCollission()).tileEntitySupplier(LensTileEntity::new));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (facing) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_WEST;
        };
    }

    public RotationType getRotationType() {
        return RotationType.HORIZROTATION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement = super.getStateForPlacement(context);
        Direction opposite = ((Direction)stateForPlacement.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
        return (BlockState)stateForPlacement.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)opposite);
    }
}

