/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.api.fluid.ILiquidCrystalData;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.PurifierConfig;
import mcjty.deepresonance.modules.tank.util.DualTankHook;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.InventoryLocator;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class PurifierTileEntity
extends TickingTileEntity {
    public static final int SLOT = 0;
    private final DualTankHook tankHook = new DualTankHook((BlockEntity)this, Direction.UP, Direction.DOWN).allowDuplicates().setTimeout(10);
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific((Item[])new Item[]{(Item)CoreModule.FILTER_MATERIAL_ITEM.get()}).in().out(), 0, 64, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match(CoreModule.FILTER_MATERIAL_ITEM)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<PurifierTileEntity, GenericItemHandler> ITEMS_CAP = tile -> tile.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<PurifierTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Purifier").containerSupplier(DefaultContainerProvider.container(MachinesModule.PURIFIER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    private final InventoryLocator inventoryLocator = new InventoryLocator();
    private int timeToGo = 0;
    private ILiquidCrystalData processing = null;

    public PurifierTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_PURIFIER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(PurifierTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    public void tickServer() {
        if (!this.tankHook.checkTanks()) {
            this.maybeOutput();
            return;
        }
        if (this.timeToGo >= 0) {
            if (!this.hasFilter()) {
                return;
            }
            if (this.timeToGo == 0) {
                this.maybeOutput();
                return;
            }
            --this.timeToGo;
        } else {
            if (!LiquidCrystalData.isValidLiquidCrystalStack(this.tankHook.getTank1().drain(1, IFluidHandler.FluidAction.SIMULATE))) {
                this.timeToGo = 20;
                return;
            }
            this.processing = LiquidCrystalData.fromStack(this.tankHook.getTank1().drain(((Integer)PurifierConfig.RCL_PER_PURIFY.get()).intValue(), IFluidHandler.FluidAction.EXECUTE));
            this.timeToGo = (Integer)PurifierConfig.TICKS_PER_PURIFY.get();
        }
        this.setChanged();
    }

    private void maybeOutput() {
        if (this.processing != null) {
            if (!this.hasFilter()) {
                return;
            }
            int purify = this.doPurify(this.processing);
            if (purify < 0) {
                return;
            }
            if (this.level.random.nextInt(purify) == 0) {
                this.consumeFilter();
            }
        }
        this.timeToGo = -1;
        this.setChanged();
    }

    private void consumeFilter() {
        this.items.decrStackSize(0, 1);
        ItemStack spentMaterial = new ItemStack((ItemLike)CoreModule.SPENT_FILTER_ITEM.get(), 1);
        this.inventoryLocator.ejectStack(this.level, this.worldPosition, spentMaterial, this.worldPosition, OrientationTools.HORIZONTAL_DIRECTION_VALUES);
    }

    private int doPurify(@Nonnull ILiquidCrystalData fluidData) {
        double maxPurityToAdd;
        if (!this.tankHook.tank2Present()) {
            return -1;
        }
        IFluidHandler outputTank = this.tankHook.getTank2();
        int tryAmount = outputTank.fill(fluidData.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
        if (tryAmount != fluidData.getAmount()) {
            return -1;
        }
        double purity = fluidData.getPurity();
        double addedPurity = maxPurityToAdd = (double)((Integer)PurifierConfig.ADDED_PURITY.get()).intValue() / 100.0;
        double maxPurity = ((double)((Integer)PurifierConfig.MAX_PURITY.get()).intValue() + 0.1) / 100.0;
        if (purity + addedPurity > (maxPurity *= fluidData.getQuality()) && (addedPurity = maxPurity - purity) < 1.0E-4) {
            outputTank.fill(fluidData.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
            this.processing = null;
            return 100000;
        }
        fluidData.setPurity(purity += addedPurity);
        outputTank.fill(fluidData.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
        this.processing = null;
        return (int)((maxPurityToAdd - addedPurity) * 40.0 / maxPurityToAdd + 1.0);
    }

    private boolean hasFilter() {
        return this.items.getStackInSlot(0).getItem() == CoreModule.FILTER_MATERIAL_ITEM.get();
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putInt("timeToGo", this.timeToGo);
        if (this.processing != null) {
            tagCompound.put("processing", this.processing.getFluidStack().saveOptional(provider));
        }
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.timeToGo = tagCompound.getInt("timeToGo");
        this.processing = tagCompound.contains("processing") ? LiquidCrystalData.fromStack(FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagCompound.getCompound("processing"))) : null;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }
}

