/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.SmelterConfig;
import mcjty.deepresonance.modules.tank.util.DualTankHook;
import mcjty.deepresonance.util.DeepResonanceTags;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.TagTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SmelterTileEntity
extends TickingTileEntity {
    public static final int SLOT = 0;
    private final DualTankHook tankHook = new DualTankHook((BlockEntity)this, Direction.DOWN, Direction.UP);
    @GuiValue
    private int processTimeLeft = 0;
    @GuiValue
    private int processTime = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.generic().in().out(), 0, 64, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((integer, itemStack) -> itemStack.is(DeepResonanceTags.RESONANT_ORE_ITEM)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<SmelterTileEntity, GenericItemHandler> ITEMS_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)SmelterConfig.POWER_MAXIMUM.get()).intValue(), (long)((Integer)SmelterConfig.POWER_PER_TICK_IN.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<SmelterTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<SmelterTileEntity, MenuProvider> screenHandler = be -> new DefaultContainerProvider("Smelter").containerSupplier(DefaultContainerProvider.container(MachinesModule.SMELTER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)be)).energyHandler(() -> be.energyStorage).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    private float finalQuality = 1.0f;
    private float finalPurity = 0.1f;

    public SmelterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_SMELTER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(SmelterTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{BlockStateProperties.POWERED});
            }
        };
    }

    public void tickServer() {
        if (this.processTimeLeft > 0) {
            if (this.canWork()) {
                --this.processTimeLeft;
                this.energyStorage.consumeEnergy((long)((Integer)SmelterConfig.POWER_PER_ORE_TICK.get()).intValue());
                if (this.processTimeLeft == 0) {
                    this.finishSmelting();
                }
            }
        } else {
            boolean newworking;
            BlockState state = this.level.getBlockState(this.getBlockPos());
            boolean oldworking = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
            if (this.canWork() && this.inputSlotValid()) {
                this.startSmelting();
                newworking = true;
            } else {
                newworking = false;
            }
            if (newworking != oldworking) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(newworking));
                this.level.setBlock(this.getBlockPos(), state, 11);
            }
        }
    }

    private boolean canWork() {
        if (!this.tankHook.checkTankContents((Fluid)Fluids.LAVA, null)) {
            return false;
        }
        if ((double)this.tankHook.getTank1().getFluidInTank(0).getAmount() < (double)this.tankHook.getTank1().getTankCapacity(0) * 0.25) {
            return false;
        }
        int fill = (Integer)SmelterConfig.RCL_PER_ORE.get();
        if (this.tankHook.getTank2().fill(LiquidCrystalData.makeLiquidCrystalStack(fill), IFluidHandler.FluidAction.SIMULATE) != fill) {
            return false;
        }
        return this.energyStorage.getEnergyStored() >= (Integer)SmelterConfig.POWER_PER_ORE_TICK.get();
    }

    private boolean inputSlotValid() {
        return !this.items.getStackInSlot(0).isEmpty() && TagTools.hasTag((Item)this.items.getStackInSlot(0).getItem(), DeepResonanceTags.RESONANT_ORE_ITEM);
    }

    private void startSmelting() {
        ItemStack stack = this.items.extractItem(0, 1, false);
        if (stack.isEmpty()) {
            return;
        }
        IFluidHandler lavaTank = this.tankHook.getTank1();
        float percentage = (float)lavaTank.getFluidInTank(0).getAmount() / (float)lavaTank.getTankCapacity(0);
        if (percentage < 0.4f) {
            this.finalQuality = 1.0f - (0.4f - percentage);
            this.finalPurity = 0.1f;
        } else if (percentage > 0.75f) {
            this.finalQuality = -1.0f;
            this.finalPurity = 0.0f;
        } else if (percentage > 0.6f) {
            this.finalQuality = 1.0f - (percentage - 0.6f) * 6.666f;
            this.finalPurity = 0.1f - (percentage - 0.6f) * 0.3f;
        } else {
            this.finalQuality = 1.0f;
            this.finalPurity = 0.1f;
        }
        lavaTank.drain(new FluidStack((Fluid)Fluids.LAVA, ((Integer)SmelterConfig.LAVA_COST.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
        int processTimeConfig = (Integer)SmelterConfig.PROCESS_TIME.get();
        this.processTime = this.processTimeLeft = (int)((short)(processTimeConfig + (int)((percentage - 0.5f) * (float)processTimeConfig)));
    }

    private void finishSmelting() {
        if (this.finalQuality > 0.0f) {
            FluidStack stack = LiquidCrystalData.makeLiquidCrystalStack((Integer)SmelterConfig.RCL_PER_ORE.get(), this.finalQuality, this.finalPurity, 0.1f, 0.1f);
            this.tankHook.getTank2().fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("processTime", this.processTime);
        tag.putInt("processTimeLeft", this.processTimeLeft);
        tag.putFloat("finalQuality", this.finalQuality);
        tag.putFloat("finalPurity", this.finalPurity);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.processTime = (short)tag.getInt("processTime");
        this.processTimeLeft = (short)tag.getInt("processTimeLeft");
        this.finalQuality = tag.getFloat("finalQuality");
        this.finalPurity = tag.getFloat("finalPurity");
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
    }

    public int getProgress() {
        if (this.processTime == 0) {
            return 0;
        }
        return (int)((float)(this.processTime - this.processTimeLeft) / (float)this.processTime * 100.0f);
    }

    public int getMaxPower() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getCurrentPower() {
        return this.energyStorage.getEnergyStored();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }
}

