/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.data.ValveData;
import mcjty.deepresonance.modules.machines.util.config.ValveConfig;
import mcjty.deepresonance.modules.tank.util.DualTankHook;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ValveTileEntity
extends TickingTileEntity {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0).playerSlots(10, 70));
    @Cap(type=CapType.CONTAINER)
    private static final Function<ValveTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Valve").containerSupplier(DefaultContainerProvider.container(MachinesModule.VALVE_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)be)).data(MachinesModule.VALVE_DATA, ValveData.STREAM_CODEC, ValveData.CODEC).setupSync((GenericTileEntity)be);
    private final DualTankHook tankHook = new DualTankHook((BlockEntity)this, Direction.UP, Direction.DOWN);
    private int progress = 0;
    @GuiValue
    public static final Value<?, Float> VALUE_MINPURITY = Value.create((String)"minPurity", (Type)Type.FLOAT, ValveTileEntity::getMinPurity, ValveTileEntity::setMinPurity);
    @GuiValue
    public static final Value<?, Float> VALUE_STRENGTH = Value.create((String)"minStrength", (Type)Type.FLOAT, ValveTileEntity::getMinStrength, ValveTileEntity::setMinStrength);
    @GuiValue
    public static final Value<?, Float> VALUE_EFFICIENCY = Value.create((String)"minEfficiency", (Type)Type.FLOAT, ValveTileEntity::getMinEfficiency, ValveTileEntity::setMinEfficiency);
    @GuiValue
    public static final Value<?, Integer> VALUE_MAXMB = Value.create((String)"maxMb", (Type)Type.INTEGER, ValveTileEntity::getMaxMb, ValveTileEntity::setMaxMb);

    public ValveTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_VALVE.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(ValveTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[0]);
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void tickServer() {
        if (!this.isMachineEnabled()) {
            return;
        }
        --this.progress;
        this.setChanged();
        if (this.progress > 0) {
            return;
        }
        this.progress = (Integer)ValveConfig.TICKS_PER_OPERATION.get();
        if (!this.tankHook.checkTanks()) {
            return;
        }
        IFluidHandler top = this.tankHook.getTank1();
        IFluidHandler bottom = this.tankHook.getTank2();
        int rcl = (Integer)ValveConfig.RCL_PER_OPERATION.get();
        FluidStack fluidStack = top.drain(rcl, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty()) {
            return;
        }
        int amt = fluidStack.getAmount();
        if (bottom.fill(LiquidCrystalData.makeLiquidCrystalStack(amt), IFluidHandler.FluidAction.SIMULATE) == amt) {
            LiquidCrystalData data = LiquidCrystalData.fromStack(fluidStack);
            if (data.getPurity() < (double)this.getMinPurity()) {
                return;
            }
            if (data.getStrength() < (double)this.getMinStrength()) {
                return;
            }
            if (data.getEfficiency() < (double)this.getMinEfficiency()) {
                return;
            }
            int maxMb = this.getMaxMb();
            if (maxMb > 0) {
                int fluidAmount = bottom.getFluidInTank(0).getAmount();
                if (fluidAmount < maxMb) {
                    int toDrain = Math.min(maxMb - fluidAmount, rcl);
                    fluidStack = top.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                    bottom.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                fluidStack = top.drain(rcl, IFluidHandler.FluidAction.EXECUTE);
                bottom.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int getMaxMb() {
        return ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).maxMb();
    }

    public void setMaxMb(int maxMb) {
        this.setData((Supplier)MachinesModule.VALVE_DATA, ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).withMaxMb(maxMb));
    }

    public float getMinEfficiency() {
        return ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).minEfficiency();
    }

    public void setMinEfficiency(float minEfficiency) {
        this.setData((Supplier)MachinesModule.VALVE_DATA, ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).withMinEfficiency(minEfficiency));
    }

    public float getMinPurity() {
        return ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).minPurity();
    }

    public void setMinPurity(float minPurity) {
        this.setData((Supplier)MachinesModule.VALVE_DATA, ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).withMinPurity(minPurity));
    }

    public float getMinStrength() {
        return ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).minStrength();
    }

    public void setMinStrength(float minStrength) {
        this.setData((Supplier)MachinesModule.VALVE_DATA, ((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)).withMinStrength(minStrength));
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putInt("progress", this.progress);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.progress = tagCompound.getInt("progress");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        ValveData valveData = (ValveData)input.get(MachinesModule.ITEM_VALVE_DATA);
        if (valveData != null) {
            this.setData((Supplier)MachinesModule.VALVE_DATA, valveData);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MachinesModule.ITEM_VALVE_DATA, (Object)((ValveData)this.getData((Supplier)MachinesModule.VALVE_DATA)));
    }
}

