/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import java.awt.Rectangle;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.CrystallizerTileEntity;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class CrystallizerGui
extends GenericGuiContainer<CrystallizerTileEntity, GenericContainer> {
    public static final int CRYSTALIZER_WIDTH = 180;
    public static final int CRYSTALIZER_HEIGHT = 152;
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"textures/gui/crystallizer.png");
    private EnergyBar energyBar;
    private Label percentage;

    public CrystallizerGui(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ManualEntry.EMPTY);
        this.imageWidth = 180;
        this.imageHeight = 152;
    }

    public void init() {
        super.init();
        CrystallizerTileEntity be = (CrystallizerTileEntity)this.getBE();
        long maxEnergyStored = be.getMaxPower();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue(maxEnergyStored).hint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).showText(false).value((long)be.getCurrentPower());
        this.percentage = (Label)new Label().hint((LayoutHint)new PositionalLayout.PositionalHint(54, 44, 32, 14));
        Panel toplevel = (Panel)((Panel)new Panel().background(GUI)).layout((Layout)new PositionalLayout()).children(new Widget[]{this.energyBar, this.percentage});
        toplevel.setBounds(new Rectangle(this.leftPos, this.topPos, this.imageWidth, this.imageHeight));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        CrystallizerTileEntity be = (CrystallizerTileEntity)this.getBE();
        this.percentage.text(be.getProgress() + "%");
        this.updateEnergyBar(this.energyBar);
        super.renderBg(graphics, partialTicks, x, y);
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(MachinesModule.CRYSTALIZER_CONTAINER.get(), CrystallizerGui::new);
    }
}

