/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.CrystallizerTileEntity;
import mcjty.lib.client.RenderHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;

public class CrystallizerRenderer
implements BlockEntityRenderer<CrystallizerTileEntity> {
    private static final ItemStack stack = new ItemStack((ItemLike)CoreModule.RESONATING_CRYSTAL_GENERATED.block().get());

    public CrystallizerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)MachinesModule.TYPE_CRYSTALIZER.get()), CrystallizerRenderer::new);
    }

    public void render(@Nonnull CrystallizerTileEntity tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int progress = tile.getProgress();
        if (tile.hasCrystal()) {
            progress = 100;
        }
        if (progress > 0) {
            matrixStack.pushPose();
            float scale = 0.75f + 0.45f * ((float)progress / 100.0f);
            float f = Math.floorMod(tile.getLevel().getGameTime(), 120);
            matrixStack.translate(0.5, 0.35 + 0.0 * (double)progress, 0.5);
            RenderHelper.rotateYP((PoseStack)matrixStack, (float)(f * 3.0f));
            matrixStack.scale(scale, scale, scale);
            RenderHelper.renderItemGround((PoseStack)matrixStack, (MultiBufferSource)buffer, (RenderType)RenderType.solid(), (ItemStack)stack, (int)0x780078, (int)combinedOverlay);
            matrixStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(CrystallizerTileEntity be) {
        BlockPos pos = be.getBlockPos();
        return new AABB((double)(pos.getX() - 10), (double)(pos.getY() - 10), (double)(pos.getZ() - 10), (double)(pos.getX() + 10), (double)(pos.getY() + 10), (double)(pos.getZ() + 10));
    }
}

