/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.LaserTileEntity;
import mcjty.deepresonance.setup.ClientSetup;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LaserRenderer
implements BlockEntityRenderer<LaserTileEntity> {
    public static final Vec3 START = new Vec3(0.5, 0.5, 0.5);

    public LaserRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)MachinesModule.TYPE_LASER.get()), LaserRenderer::new);
    }

    public void render(@Nonnull LaserTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        int color = (Integer)tileEntity.getBlockState().getValue((Property)LaserTileEntity.COLOR);
        VertexConsumer buf = buffer.getBuffer(RenderType.TRANSLUCENT);
        this.renderInternal(tileEntity.getBlockPos(), color, matrixStack, buf);
    }

    private void renderInternal(BlockPos pos, int color, PoseStack matrixStack, VertexConsumer builder) {
        if (color != 0) {
            Direction direction = OrientationTools.getOrientationHoriz((BlockState)Minecraft.getInstance().level.getBlockState(pos));
            float destX = 0.5f + (float)direction.getStepX() * 2.5f;
            float destY = 0.5f;
            float destZ = 0.5f + (float)direction.getStepZ() * 2.5f;
            ResourceLocation laser = switch (color) {
                case 1 -> ClientSetup.BLUELASER;
                case 2 -> ClientSetup.REDLASER;
                case 3 -> ClientSetup.GREENLASER;
                case 4 -> ClientSetup.YELLOWLASER;
                default -> null;
            };
            int tex = pos.getX();
            int tey = pos.getY();
            int tez = pos.getZ();
            Vec3 player = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().add((double)(-tex), (double)(-tey), (double)(-tez));
            Vec3 end = new Vec3((double)destX, (double)destY, (double)destZ);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(laser);
            matrixStack.pushPose();
            RenderSettings settingsLaser = RenderSettings.builder().width(0.25f).alpha(128).build();
            RenderHelper.drawBeam((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (Vec3)START, (Vec3)end, (Vec3)player, (RenderSettings)settingsLaser);
            matrixStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(LaserTileEntity be) {
        BlockPos pos = be.getBlockPos();
        return new AABB((double)(pos.getX() - 10), (double)(pos.getY() - 10), (double)(pos.getZ() - 10), (double)(pos.getX() + 10), (double)(pos.getY() + 10), (double)(pos.getZ() + 10));
    }
}

