/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import java.awt.Rectangle;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.SmelterTileEntity;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class SmelterGui
extends GenericGuiContainer<SmelterTileEntity, GenericContainer> {
    public static final int SMELTER_WIDTH = 180;
    public static final int SMELTER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageLabel burningImage;
    private Label percentage;
    private static final ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"textures/gui/smelter.png");
    private static final ResourceLocation iconBurning = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"textures/gui/burning.png");

    public SmelterGui(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ManualEntry.EMPTY);
        this.imageWidth = 180;
        this.imageHeight = 152;
    }

    public void init() {
        super.init();
        SmelterTileEntity be = (SmelterTileEntity)this.getBE();
        long maxEnergyStored = be.getMaxPower();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue(maxEnergyStored).hint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).showText(false);
        this.energyBar.value((long)be.getCurrentPower());
        this.burningImage = (ImageLabel)((ImageLabel)new ImageLabel().image(iconBurning, 0, 0)).hint((LayoutHint)new PositionalLayout.PositionalHint(90, 2, 64, 64));
        this.percentage = (Label)new Label().hint((LayoutHint)new PositionalLayout.PositionalHint(54, 44, 32, 14));
        Panel toplevel = (Panel)((Panel)new Panel().background(iconLocation)).layout((Layout)new PositionalLayout()).children(new Widget[]{this.energyBar, this.burningImage, this.percentage});
        toplevel.setBounds(new Rectangle(this.leftPos, this.topPos, this.imageWidth, this.imageHeight));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        SmelterTileEntity be = (SmelterTileEntity)this.getBE();
        int progress = be.getProgress();
        if (0 < progress && progress < 100) {
            int p = progress / 3 % 9 + 1;
            int xx = p % 4 * 64;
            int yy = p / 4 * 64;
            this.burningImage.image(iconBurning, xx, yy);
        } else {
            this.burningImage.image(iconBurning, 0, 0);
        }
        this.percentage.text(progress + "%");
        this.updateEnergyBar(this.energyBar);
        super.renderBg(graphics, partialTicks, x, y);
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(MachinesModule.SMELTER_CONTAINER.get(), SmelterGui::new);
    }
}

