/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ValveData(float minPurity, float minStrength, float minEfficiency, int maxMb) {
    public static final ValveData DEFAULT = new ValveData(1.0f, 1.0f, 1.0f, 0);
    public static final Codec<ValveData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("minpurity").forGetter(ValveData::minPurity), (App)Codec.FLOAT.fieldOf("minstrength").forGetter(ValveData::minStrength), (App)Codec.FLOAT.fieldOf("minefficiency").forGetter(ValveData::minEfficiency), (App)Codec.INT.fieldOf("maxmb").forGetter(ValveData::maxMb)).apply((Applicative)instance, ValveData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ValveData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, ValveData::minPurity, (StreamCodec)ByteBufCodecs.FLOAT, ValveData::minStrength, (StreamCodec)ByteBufCodecs.FLOAT, ValveData::minEfficiency, (StreamCodec)ByteBufCodecs.INT, ValveData::maxMb, ValveData::new);

    public ValveData withMinPurity(float minPurity) {
        return new ValveData(minPurity, this.minStrength, this.minEfficiency, this.maxMb);
    }

    public ValveData withMinStrength(float minStrength) {
        return new ValveData(this.minPurity, minStrength, this.minEfficiency, this.maxMb);
    }

    public ValveData withMinEfficiency(float minEfficiency) {
        return new ValveData(this.minPurity, this.minStrength, minEfficiency, this.maxMb);
    }

    public ValveData withMaxMb(int maxMb) {
        return new ValveData(this.minPurity, this.minStrength, this.minEfficiency, maxMb);
    }
}

