/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.util.config;

import mcjty.deepresonance.setup.Config;
import net.neoforged.neoforge.common.ModConfigSpec;

public class LaserConfig {
    public static ModConfigSpec.IntValue POWER_PER_TICK_IN;
    public static ModConfigSpec.IntValue POWER_MAXIMUM;
    public static ModConfigSpec.IntValue CRYSTAL_LIQUID_MAXIMUM;
    public static ModConfigSpec.IntValue MIN_CRYSTAL_LIQUID_PER_CRYSTAL;
    public static ModConfigSpec.IntValue MAX_CRYSTAL_LIQUID_PER_CRYSTAL;
    public static ModConfigSpec.IntValue RFUSE_PER_CATALYST;
    public static ModConfigSpec.IntValue TICKS10_PER_CATALYST;
    public static ModConfigSpec.IntValue RCL_PER_CATALYST;
    public static ModConfigSpec.IntValue CRYSTAL_LIQUID_PER_CATALYST;

    public static void init() {
        Config.SERVER_BUILDER.push("laser");
        POWER_PER_TICK_IN = Config.SERVER_BUILDER.comment("How much power/t this machine can input from a generator/capacitor").defineInRange("powerPerTickIn", 2000, 0, Integer.MAX_VALUE);
        POWER_MAXIMUM = Config.SERVER_BUILDER.comment("Maximum power that can be stored in this machine").defineInRange("powerMaximum", 100000, 0, Integer.MAX_VALUE);
        CRYSTAL_LIQUID_MAXIMUM = Config.SERVER_BUILDER.comment("The maximum amount of liquified crystal this machine can hold (this is not RCL!)").defineInRange("crystalLiquidMaximum", 20000, 100, Integer.MAX_VALUE);
        MIN_CRYSTAL_LIQUID_PER_CRYSTAL = Config.SERVER_BUILDER.comment("The minimum amount of liquified crystal one crystal will yield (this is not RCL!). This value is for a 0% strength crystal").defineInRange("minCrystalLiquidPerCrystal", 2000, 1, Integer.MAX_VALUE);
        MAX_CRYSTAL_LIQUID_PER_CRYSTAL = Config.SERVER_BUILDER.comment("The maximum amount of liquified crystal one crystal will yield (this is not RCL!). This value is for a 100% strength crystal").defineInRange("maxCrystalLiquidPerCrystal", 10000, 1, Integer.MAX_VALUE);
        RFUSE_PER_CATALYST = Config.SERVER_BUILDER.comment("How much RF this machine consumes for infusing one catalyst item").defineInRange("rfUsePerCatalyst", 4000, 0, Integer.MAX_VALUE);
        TICKS10_PER_CATALYST = Config.SERVER_BUILDER.comment("How many multiples of 10 ticks are needed to infuse one catalyst item").defineInRange("ticks10PerCatalyst", 4, 0, 100000);
        CRYSTAL_LIQUID_PER_CATALYST = Config.SERVER_BUILDER.comment("The amount of crystal liquid we consume per catalyst item").defineInRange("crystalLiquidPerCatalyst", 25, 1, Integer.MAX_VALUE);
        RCL_PER_CATALYST = Config.SERVER_BUILDER.comment("The amount of crystal liquid we consume per catalyst item").defineInRange("rclPerCatalyst", 500, 1, Integer.MAX_VALUE);
        Config.SERVER_BUILDER.pop();
    }
}

