/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.pedestal.block;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.deepresonance.compat.DeepResonanceTOPDriver;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.core.data.Crystal;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorBlock;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.util.CollectorConfig;
import mcjty.deepresonance.modules.pedestal.PedestalModule;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.InventoryLocator;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.SoundTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.Lazy;

public class PedestalTileEntity
extends TickingTileEntity {
    public static final int SLOT_CRYSTAL = 0;
    private static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(PedestalTileEntity::isValidCrystal).in(), 0, 64, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> PedestalTileEntity.isValidCrystal(stack)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<PedestalTileEntity, GenericItemHandler> ITEMS_CAP = tile -> tile.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<PedestalTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Pedestal").containerSupplier(DefaultContainerProvider.container(PedestalModule.CONTAINER_PEDESTAL, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    private int checkCounter = 0;
    private final InventoryLocator inventoryLocator = new InventoryLocator();
    private BlockPos cachedLocator = null;
    private static Direction[] directions = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN};

    public PedestalTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PedestalModule.TYPE_PEDESTAL.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(PedestalTileEntity::new).topDriver((TOPDriver)DeepResonanceTOPDriver.DRIVER).infusable().info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    }

    public void tickServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 20;
        BlockPos b = this.getCrystalPosition();
        if (this.level.getBlockState(b).isAir()) {
            this.placeCrystal();
        } else if (this.level.getBlockState(b).getBlock() instanceof ResonatingCrystalBlock) {
            this.checkCrystal();
        }
    }

    public BlockPos getCrystalPosition() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        Direction orientation = OrientationTools.getOrientation((BlockState)state);
        return this.worldPosition.relative(orientation);
    }

    public Optional<ResonatingCrystalTileEntity> getCrystal() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.getCrystalPosition());
        if (blockEntity instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)blockEntity;
            return Optional.of(crystal);
        }
        return Optional.empty();
    }

    public boolean crystalPresent() {
        return this.level.getBlockState(this.getCrystalPosition()).getBlock() instanceof ResonatingCrystalBlock;
    }

    private static boolean isValidCrystal(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock() instanceof ResonatingCrystalBlock;
        }
        return false;
    }

    private void placeCrystal() {
        Item item;
        BlockPos pos = this.getCrystalPosition();
        ItemStack crystalStack = this.items.getStackInSlot(0);
        if (!crystalStack.isEmpty() && (item = crystalStack.getItem()) instanceof BlockItem) {
            BlockEntity tileEntity;
            BlockItem blockItem = (BlockItem)item;
            BlockHitResult result = new BlockHitResult(Vec3.ZERO, Direction.UP, pos, false);
            BlockPlaceContext context = new BlockPlaceContext((Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.level)), InteractionHand.MAIN_HAND, crystalStack, result);
            blockItem.place(context);
            ResonatingCrystalBlock b = (ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.block().get());
            SoundTools.playSound((Level)this.level, (SoundEvent)b.defaultBlockState().getSoundType((LevelReader)this.level, pos, null).getBreakSound(), (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)1.0, (double)1.0);
            if (this.findCollector() && (tileEntity = this.level.getBlockEntity(new BlockPos((Vec3i)this.cachedLocator))) instanceof EnergyCollectorTileEntity) {
                EnergyCollectorTileEntity collector = (EnergyCollectorTileEntity)tileEntity;
                collector.addCrystal(pos.getX(), pos.getY(), pos.getZ());
            }
        }
    }

    private void checkCrystal() {
        Optional<Boolean> powerLow = this.getCrystal().map(tile -> tile.getPower() <= (double)1.0E-5f);
        if (powerLow.orElse(false).booleanValue()) {
            this.dropCrystal();
        }
    }

    public void dropCrystal() {
        this.getCrystal().ifPresent(crystal -> {
            BlockPos p = crystal.getBlockPos();
            BlockState crystalState = this.level.getBlockState(p);
            Block patt0$temp = crystalState.getBlock();
            if (patt0$temp instanceof ResonatingCrystalBlock) {
                ResonatingCrystalBlock crystalBlock = (ResonatingCrystalBlock)patt0$temp;
                ItemStack spentCrystal = new ItemStack((ItemLike)crystalBlock.getEmpty(), 1);
                Crystal data = (Crystal)crystal.getData((Supplier)CoreModule.CRYSTAL_DATA);
                spentCrystal.set(CoreModule.ITEM_CRYSTAL_DATA, (Object)data);
                this.inventoryLocator.ejectStack(this.level, this.worldPosition, spentCrystal, this.worldPosition, directions);
                this.level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
                SoundTools.playSound((Level)this.level, (SoundEvent)crystalState.getSoundType().getBreakSound(), (double)p.getX(), (double)p.getY(), (double)p.getZ(), (double)1.0, (double)1.0);
            }
        });
    }

    private boolean findCollector() {
        BlockPos crystalLocation = this.getCrystalPosition();
        if (this.cachedLocator != null) {
            if (this.level.getBlockState(this.cachedLocator).getBlock() instanceof EnergyCollectorBlock) {
                return true;
            }
            this.cachedLocator = null;
        }
        float closestDistance = Float.MAX_VALUE;
        int yy = crystalLocation.getY();
        int xx = crystalLocation.getX();
        int zz = crystalLocation.getZ();
        for (int y = yy - (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); y <= yy + (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); ++y) {
            if (y < 0 || y >= this.level.getHeight()) continue;
            int maxhordist = (Integer)CollectorConfig.MAX_HORIZONTAL_CRYSTAL_DISTANCE.get();
            for (int x = xx - maxhordist; x <= xx + maxhordist; ++x) {
                for (int z = zz - maxhordist; z <= zz + maxhordist; ++z) {
                    double sqdist;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!(this.level.getBlockState(pos).getBlock() instanceof EnergyCollectorBlock) || !((sqdist = pos.distSqr((Vec3i)crystalLocation)) < (double)closestDistance)) continue;
                    closestDistance = (float)sqdist;
                    this.cachedLocator = pos;
                }
            }
        }
        return this.cachedLocator != null;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }
}

