/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.item;

import java.util.List;
import java.util.Map;
import mcjty.deepresonance.api.armor.IRadiationArmor;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.deepresonance.setup.Registration;
import mcjty.lib.items.GenericArmorItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ItemRadiationSuit
extends GenericArmorItem
implements IRadiationArmor {
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ARMOR_MATERIAL = Registration.ARMOR_MATERIALS.register("resonating_armor", () -> new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, 1, ArmorItem.Type.CHESTPLATE, 4, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.BOOTS, 2, ArmorItem.Type.BODY, 0), 12, SoundEvents.ARMOR_EQUIP_DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CoreModule.RESONATING_PLATE_ITEM.get()}), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"resonating_armor"))), 0.5f, 0.0f));

    public static void init() {
    }

    public ItemRadiationSuit(EquipmentSlot slot) {
        super(ARMOR_MATERIAL, slot, Registration.createStandardProperties());
    }

    public static float getRadiationProtection(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = entity.getItemBySlot(slot)).isEmpty()) continue;
            int count = ItemRadiationSuit.countSuitPieces(entity);
            if (count <= 0) {
                return 0.0f;
            }
            if (stack.getItem() instanceof IRadiationArmor && ((IRadiationArmor)stack.getItem()).isActive(stack)) {
                return ((IRadiationArmor)stack.getItem()).protection(count);
            }
            if (!ItemRadiationSuit.hasAntiRadiationFlag(stack)) continue;
            return (float)((Double)RadiationConfiguration.SUIT_PROTECTION[count].get()).doubleValue();
        }
        return 0.0f;
    }

    public static int countSuitPieces(LivingEntity entity) {
        int cnt = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack stack = entity.getItemBySlot(slot);
            if (!stack.isEmpty() && stack.getItem() instanceof IRadiationArmor && ((IRadiationArmor)stack.getItem()).isActive(stack)) {
                ++cnt;
                continue;
            }
            if (!ItemRadiationSuit.hasAntiRadiationFlag(stack)) continue;
            ++cnt;
        }
        return cnt;
    }

    private static boolean hasAntiRadiationFlag(ItemStack stack) {
        CustomData custom = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return custom != null && custom.contains("AntiRadiationArmor");
    }
}

