/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.item;

import java.util.List;
import java.util.Map;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.deepresonance.modules.radiation.manager.QuadTree;
import mcjty.deepresonance.modules.radiation.network.PacketGetRadiationLevel;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.deepresonance.setup.DeepResonanceMessages;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RadiationMonitorItem
extends Item {
    public static final ResourceLocation RADIATION_PROPERTY = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"radiation");
    private static long lastTime = 0L;
    public static float radiationStrength = 0.0f;

    public RadiationMonitorItem(Item.Properties properties) {
        super(properties);
    }

    public static void initOverrides(RadiationMonitorItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)RADIATION_PROPERTY, (stack, world, livingEntity, seed) -> {
            RadiationMonitorItem.fetchRadiation(livingEntity);
            int level = (int)((double)(10.0f * radiationStrength) / (Double)RadiationConfiguration.MAX_RADIATION_METER.get());
            if (level < 0) {
                level = 0;
            } else if (level > 9) {
                level = 9;
            }
            return level;
        });
    }

    public static float calculateRadiationStrength(Level world, GlobalPos player) {
        ResourceKey id = player.dimension();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        float maxStrength = -1.0f;
        for (Map.Entry<GlobalPos, DRRadiationManager.RadiationSource> source : radiationManager.getRadiationSources().entrySet()) {
            int cz;
            int cy;
            GlobalPos coordinate = source.getKey();
            if (coordinate.dimension() != id) continue;
            DRRadiationManager.RadiationSource radiationSource = source.getValue();
            float radius = radiationSource.getRadius();
            float radiusSq = radius * radius;
            double distanceSq = player.pos().distSqr((Vec3i)coordinate.pos());
            if (!(distanceSq < (double)radiusSq)) continue;
            double distance = Math.sqrt(distanceSq);
            float strength = (float)((double)radiationSource.getStrength() * ((double)radius - distance) / (double)radius);
            int cx = coordinate.pos().getX();
            QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy = coordinate.pos().getY(), cz = coordinate.pos().getZ());
            if (!((strength *= (float)radiationTree.factor2(cx, cy, cz, player.pos().getX(), player.pos().getY() + 1, player.pos().getZ())) > maxStrength)) continue;
            maxStrength = strength;
        }
        return maxStrength;
    }

    public static void fetchRadiation(LivingEntity player) {
        if (player == null) {
            return;
        }
        if (System.currentTimeMillis() - lastTime > 250L) {
            ResourceKey id = player.level().dimension();
            lastTime = System.currentTimeMillis();
            GlobalPos c = GlobalPos.of((ResourceKey)id, (BlockPos)player.blockPosition());
            DeepResonanceMessages.sendToServer(PacketGetRadiationLevel.create(c));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        RadiationMonitorItem.fetchRadiation((LivingEntity)SafeClientTools.getClientPlayer());
        if (radiationStrength <= 0.0f) {
            list.add((Component)ComponentFactory.literal((String)"No radiation detected").withStyle(ChatFormatting.GREEN));
        } else {
            list.add((Component)ComponentFactory.literal((String)("Radiation: " + (int)radiationStrength + "!")).withStyle(ChatFormatting.RED));
        }
    }
}

