/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.manager;

import mcjty.deepresonance.modules.radiation.util.SimpleAABB;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class QuadTree {
    private final SimpleAABB box;
    private QuadTree child1;
    private QuadTree child2;
    private float blocker = 1.0f;

    public QuadTree(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.box = SimpleAABB.getBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void addBlocker(int x, int y, int z, float blocker) {
        this.addBlocker(new BlockPos(x, y, z), blocker);
    }

    public float addBlocker(BlockPos coordinate, float blocker) {
        int axis;
        int largest;
        if (this.child1 != null) {
            if (this.child1.box.isVecInside(coordinate)) {
                float b = this.child1.addBlocker(coordinate, blocker);
                if ((double)this.child2.blocker >= 0.0 && (double)Math.abs(b - this.child2.blocker) < 0.01) {
                    this.blocker = b;
                    this.child1 = null;
                    this.child2 = null;
                    return b;
                }
                this.blocker = -1.0f;
                return -1.0f;
            }
            if (this.child2.box.isVecInside(coordinate)) {
                float b = this.child2.addBlocker(coordinate, blocker);
                if ((double)this.child1.blocker >= 0.0 && (double)Math.abs(b - this.child1.blocker) < 0.01) {
                    this.blocker = b;
                    this.child1 = null;
                    this.child2 = null;
                    return b;
                }
                this.blocker = -1.0f;
                return -1.0f;
            }
            System.out.println("Impossible! Point " + String.valueOf(coordinate) + " is not in either box!");
            System.out.println("    child1.box = " + String.valueOf(this.child1.box));
            System.out.println("    child2.box = " + String.valueOf(this.child2.box));
            this.blocker = -1.0f;
            return -1.0f;
        }
        int lx = this.box.maxX - this.box.minX;
        int ly = this.box.maxY - this.box.minY;
        int lz = this.box.maxZ - this.box.minZ;
        if (lx >= ly && lx >= lz) {
            largest = lx;
            axis = 0;
        } else if (ly >= lz) {
            largest = ly;
            axis = 1;
        } else {
            largest = lz;
            axis = 2;
        }
        if (largest > 1) {
            switch (axis) {
                case 0: {
                    int middle = (this.box.maxX + this.box.minX) / 2;
                    this.child1 = new QuadTree(this.box.minX, this.box.minY, this.box.minZ, middle, this.box.maxY, this.box.maxZ);
                    this.child2 = new QuadTree(middle, this.box.minY, this.box.minZ, this.box.maxX, this.box.maxY, this.box.maxZ);
                    break;
                }
                case 1: {
                    int middle = (this.box.maxY + this.box.minY) / 2;
                    this.child1 = new QuadTree(this.box.minX, this.box.minY, this.box.minZ, this.box.maxX, middle, this.box.maxZ);
                    this.child2 = new QuadTree(this.box.minX, middle, this.box.minZ, this.box.maxX, this.box.maxY, this.box.maxZ);
                    break;
                }
                case 2: {
                    int middle = (this.box.maxZ + this.box.minZ) / 2;
                    this.child1 = new QuadTree(this.box.minX, this.box.minY, this.box.minZ, this.box.maxX, this.box.maxY, middle);
                    this.child2 = new QuadTree(this.box.minX, this.box.minY, middle, this.box.maxX, this.box.maxY, this.box.maxZ);
                }
            }
            this.child1.blocker = this.blocker;
            this.child2.blocker = this.blocker;
            this.blocker = -1.0f;
            return this.addBlocker(coordinate, blocker);
        }
        this.blocker = blocker;
        return blocker;
    }

    public double factor(int x1, int y1, int z1, int x2, int y2, int z2) {
        Vec3 p1 = new Vec3((double)x1 + 0.5, (double)y1 + 0.5, (double)z1 + 0.5);
        Vec3 p2 = new Vec3((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5);
        return this.factor(new Ray(p1, p2));
    }

    public double factor2(int x1, int y1, int z1, int x2, int y2, int z2) {
        Vec3 p1 = new Vec3((double)x1 + 0.5, (double)y1 + 0.5, (double)z1 + 0.5);
        Vec3 p2 = new Vec3((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5);
        double f1 = this.factor(new Ray(p1, p2));
        Vec3 p3 = new Vec3((double)x2 + 0.5, (double)y2 + 1.1, (double)z2 + 0.5);
        double f2 = this.factor(new Ray(p1, p3));
        return Math.max(f1, f2);
    }

    private double factor(Ray ray) {
        if (this.child1 != null) {
            double factor = 1.0;
            if (QuadTree.testIntersect(this.child1.box, ray)) {
                factor *= this.child1.factor(ray);
            }
            if (QuadTree.testIntersect(this.child2.box, ray)) {
                factor *= this.child2.factor(ray);
            }
            return factor;
        }
        return this.blocker;
    }

    private static boolean testIntersect(SimpleAABB box, Ray ray) {
        Vec3 invDir = ray.getInvDir();
        boolean signDirX = invDir.x < 0.0;
        boolean signDirY = invDir.y < 0.0;
        boolean signDirZ = invDir.z < 0.0;
        double v = signDirX ? (double)box.maxX : (double)box.minX;
        double tmin = (v - ray.getStart().x) * invDir.x;
        v = signDirX ? (double)box.minX : (double)box.maxX;
        double tmax = (v - ray.getStart().x) * invDir.x;
        v = signDirY ? (double)box.maxY : (double)box.minY;
        double tymin = (v - ray.getStart().y) * invDir.y;
        v = signDirY ? (double)box.minY : (double)box.maxY;
        double tymax = (v - ray.getStart().y) * invDir.y;
        if (tmin > tymax || tymin > tmax) {
            return false;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        v = signDirZ ? (double)box.maxZ : (double)box.minZ;
        double tzmin = (v - ray.getStart().z) * invDir.z;
        v = signDirZ ? (double)box.minZ : (double)box.maxZ;
        double tzmax = (v - ray.getStart().z) * invDir.z;
        if (tmin > tzmax || tzmin > tmax) {
            return false;
        }
        if (tzmin > tmin) {
            tmin = tzmin;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        return tmin < ray.getLength() && tmax > 0.01;
    }

    private void dump(int indent) {
        if (this.child1 == null) {
            System.out.println("                                                                     ".substring(0, indent) + "Leaf: " + String.valueOf(this.box) + ", blocker=" + this.blocker);
        } else {
            System.out.println("                                                                     ".substring(0, indent) + "Node: " + String.valueOf(this.box));
            this.child1.dump(indent + 2);
            this.child2.dump(indent + 2);
        }
    }

    private int treeSize() {
        if (this.child1 == null) {
            return 1;
        }
        return 1 + this.child1.treeSize() + this.child2.treeSize();
    }

    public static void main(String[] args) {
        int z;
        int y;
        int dim = 100;
        QuadTree tree = new QuadTree(0, 0, 0, dim, dim, dim);
        for (y = 0; y <= 5; ++y) {
            for (z = 0; z <= dim; ++z) {
                tree.addBlocker(3, y, z, 0.5f);
                tree.addBlocker(20, y, z, 0.5f);
                tree.addBlocker(21, y, z, 0.5f);
            }
        }
        System.out.println("Twice Blocked: " + tree.factor(1, 3, 3, 40, 3, 3));
        System.out.println("Once Blocked: " + tree.factor(1, 3, 3, 10, 3, 3));
        System.out.println("Not Blocked: " + tree.factor(1, 7, 3, 8, 7, 3));
        System.out.println("tree.treeSize() = " + tree.treeSize());
        for (y = 0; y <= 5; ++y) {
            for (z = 0; z <= dim; ++z) {
                tree.addBlocker(3, y, z, 0.5f);
                tree.addBlocker(20, y, z, 1.0f);
                tree.addBlocker(21, y, z, 0.5f);
            }
        }
        System.out.println("Twice Blocked: " + tree.factor(1, 3, 3, 40, 3, 3));
        System.out.println("Once Blocked: " + tree.factor(1, 3, 3, 10, 3, 3));
        System.out.println("Not Blocked: " + tree.factor(1, 7, 3, 8, 7, 3));
        System.out.println("tree.treeSize() = " + tree.treeSize());
    }

    private static class Ray {
        private final Vec3 start;
        private final Vec3 dir;
        private final Vec3 invDir;
        private final double length;

        public Ray(Vec3 start, Vec3 end) {
            this.start = start;
            Vec3 dir = end.subtract(start);
            this.length = dir.length();
            this.dir = dir.normalize();
            this.invDir = new Vec3(1.0 / this.dir.x, 1.0 / this.dir.y, 1.0 / this.dir.z);
        }

        public Vec3 getDir() {
            return this.dir;
        }

        public Vec3 getInvDir() {
            return this.invDir;
        }

        public Vec3 getStart() {
            return this.start;
        }

        public double getLength() {
            return this.length;
        }
    }
}

