/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.manager;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mcjty.deepresonance.modules.radiation.RadiationModule;
import mcjty.deepresonance.modules.radiation.item.ItemRadiationSuit;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.deepresonance.modules.radiation.manager.QuadTree;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.TagTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class RadiationTickEvent {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static final Random random = new Random();
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;
    public static Holder<MobEffect> harm;
    public static Holder<MobEffect> hunger;
    public static Holder<MobEffect> moveSlowdown;
    public static Holder<MobEffect> weakness;
    public static Holder<MobEffect> poison;
    public static Holder<MobEffect> wither;

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post evt) {
        Level level = evt.getLevel();
        if (level.isClientSide) {
            return;
        }
        if (!Objects.equals(Level.OVERWORLD, level.dimension())) {
            return;
        }
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.serverTick(level, doEffects);
        }
    }

    private void serverTick(Level entityWorld, boolean doEffects) {
        DRRadiationManager radiationManager = DRRadiationManager.getManager(entityWorld);
        HashSet toRemove = Sets.newHashSet();
        boolean dirty = false;
        for (Map.Entry<GlobalPos, DRRadiationManager.RadiationSource> source : radiationManager.getRadiationSources().entrySet()) {
            GlobalPos coordinate = source.getKey();
            ServerLevel world = LevelTools.getLevel((Level)entityWorld, (ResourceKey)coordinate.dimension());
            if (world == null || !LevelTools.isLoaded((Level)world, (BlockPos)coordinate.pos())) continue;
            DRRadiationManager.RadiationSource radiationSource = source.getValue();
            float strength = radiationSource.getStrength();
            strength = (float)((double)strength - (Double)RadiationConfiguration.STRENGTH_DECREASE_TICK.get() * 10.0);
            dirty = true;
            if (strength <= 0.0f) {
                toRemove.add(coordinate);
                continue;
            }
            radiationSource.setStrength(strength);
            if (doEffects) {
                this.handleRadiationEffects((Level)world, coordinate, radiationSource);
            }
            if (!((double)strength > (Double)RadiationConfiguration.RADIATION_DESTRUCTION_EVENT_LEVEL.get()) || !((double)random.nextFloat() < (Double)RadiationConfiguration.RADIATION_DESTRUCTION_EVENT_CHANCE.get())) continue;
            this.handleDestructionEvent((Level)world, coordinate, radiationSource);
        }
        if (dirty) {
            for (GlobalPos coordinate : toRemove) {
                radiationManager.deleteRadiationSource(coordinate);
                Logging.logDebug((String)("Removed radiation source at: " + String.valueOf(coordinate.pos()) + " (" + String.valueOf(coordinate.dimension()) + ")"));
            }
            radiationManager.save();
        }
    }

    private void handleDestructionEvent(Level world, GlobalPos coordinate, DRRadiationManager.RadiationSource radiationSource) {
        float setOnFireChance;
        float removeLeafChance;
        float poisonBlockChance;
        int damage;
        int cx = coordinate.pos().getX();
        int cy = coordinate.pos().getY();
        int cz = coordinate.pos().getZ();
        double centerx = cx;
        double centery = cy;
        double centerz = cz;
        double radius = radiationSource.getRadius();
        double theta = random.nextDouble() * Math.PI * 2.0;
        double phi = random.nextDouble() * Math.PI - 1.5707963267948966;
        double dist = random.nextDouble() * radius;
        double cosphi = Math.cos(phi);
        double destx = centerx + dist * Math.cos(theta) * cosphi;
        double destz = centerz + dist * Math.sin(theta) * cosphi;
        double desty = random.nextFloat() > 0.5f ? (double)world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, (int)destx, (int)destz) : centery + dist * Math.sin(phi);
        Logging.logDebug((String)("Destruction event at: " + destx + "," + desty + "," + destz));
        float baseStrength = radiationSource.getStrength();
        double distanceSq = (centerx - destx) * (centerx - destx) + (centery - desty) * (centery - desty) + (centerz - destz) * (centerz - destz);
        double distance = Math.sqrt(distanceSq);
        float strength = (float)((double)baseStrength * (radius - distance) / radius);
        QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy, cz);
        strength *= (float)radiationTree.factor(cx, cy, cz, (int)destx, (int)desty, (int)destz);
        int eventradius = 8;
        if ((double)strength > (Double)RadiationConfiguration.RADIATION_DESTRUCTION_EVENT_LEVEL.get() / 2.0) {
            damage = 30;
            poisonBlockChance = 0.9f;
            removeLeafChance = 9.0f;
            setOnFireChance = 0.03f;
        } else if ((double)strength > (Double)RadiationConfiguration.RADIATION_DESTRUCTION_EVENT_LEVEL.get() / 3.0) {
            damage = 5;
            poisonBlockChance = 0.6f;
            removeLeafChance = 4.0f;
            setOnFireChance = 0.001f;
        } else if ((double)strength > (Double)RadiationConfiguration.RADIATION_DESTRUCTION_EVENT_LEVEL.get() / 4.0) {
            damage = 1;
            poisonBlockChance = 0.3f;
            removeLeafChance = 1.2f;
            setOnFireChance = 0.0f;
        } else {
            return;
        }
        AABB area = new AABB(destx - (double)eventradius, desty - (double)eventradius, destz - (double)eventradius, destx + (double)eventradius, desty + (double)eventradius, destz + (double)eventradius);
        List list = world.getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity entityLivingBase : list) {
            RadiationTickEvent.getPotions();
            entityLivingBase.addEffect(new MobEffectInstance(harm, 10, damage));
        }
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        int x = (int)(destx - (double)eventradius);
        while ((double)x <= destx + (double)eventradius) {
            int y = (int)(desty - (double)eventradius);
            while ((double)y <= desty + (double)eventradius) {
                int z = (int)(destz - (double)eventradius);
                while ((double)z <= destz + (double)eventradius) {
                    double dSq = ((double)x - destx) * ((double)x - destx) + ((double)y - desty) * ((double)y - desty) + ((double)z - destz) * ((double)z - destz);
                    double d = Math.sqrt(dSq);
                    double str = ((double)eventradius - d) / (double)eventradius;
                    Block block = world.getBlockState((BlockPos)(currentPos = currentPos.set(x, y, z))).getBlock();
                    if (TagTools.hasTag((Block)block, (TagKey)BlockTags.DIRT) || block == Blocks.FARMLAND || block == Blocks.GRASS_BLOCK) {
                        if ((double)random.nextFloat() < (double)poisonBlockChance * str) {
                            world.setBlock((BlockPos)currentPos, ((Block)RadiationModule.POISONED_DIRT.block().get()).defaultBlockState(), 3);
                        }
                    } else if ((TagTools.hasTag((Block)block, (TagKey)BlockTags.LEAVES) || block instanceof SpecialPlantable) && (double)random.nextFloat() < (double)removeLeafChance * str) {
                        world.setBlock((BlockPos)currentPos, Blocks.AIR.defaultBlockState(), 3);
                    }
                    if ((double)random.nextFloat() < (double)setOnFireChance * str) {
                        // empty if block
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private static void getPotions() {
        if (harm == null) {
            harm = RadiationTickEvent.getEffect("instant_damage");
            hunger = RadiationTickEvent.getEffect("hunger");
            moveSlowdown = RadiationTickEvent.getEffect("slowness");
            weakness = RadiationTickEvent.getEffect("weakness");
            poison = RadiationTickEvent.getEffect("poison");
            wither = RadiationTickEvent.getEffect("wither");
        }
    }

    private static Holder<MobEffect> getEffect(String name) {
        ResourceLocation id = ResourceLocation.parse((String)name);
        return (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)id)).orElseThrow(() -> new IllegalStateException("Unknown effect: " + name));
    }

    private void handleRadiationEffects(Level world, GlobalPos coordinate, DRRadiationManager.RadiationSource radiationSource) {
        int cx = coordinate.pos().getX();
        int cy = coordinate.pos().getY();
        int cz = coordinate.pos().getZ();
        double centerx = cx;
        double centery = cy;
        double centerz = cz;
        double radius = radiationSource.getRadius();
        double radiusSq = radius * radius;
        float baseStrength = radiationSource.getStrength();
        AABB area = new AABB(centerx - radius, centery - radius, centerz - radius, centerx + radius, centery + radius, centerz + radius);
        List list = world.getEntitiesOfClass(LivingEntity.class, area, livingEntity -> true);
        for (LivingEntity entityLivingBase : list) {
            float protection = ItemRadiationSuit.getRadiationProtection(entityLivingBase);
            double distanceSq = entityLivingBase.blockPosition().distToCenterSqr(centerx, centery, centerz);
            if (!(distanceSq < radiusSq)) continue;
            double distance = Math.sqrt(distanceSq);
            QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy, cz);
            float strength = (float)((double)baseStrength * (radius - distance) / radius);
            strength *= 1.0f - protection;
            RadiationTickEvent.getPotions();
            if ((double)(strength *= (float)radiationTree.factor2(cx, cy, cz, (int)entityLivingBase.position().x, (int)entityLivingBase.position().y + 1, (int)entityLivingBase.position().z)) < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_0.get()) continue;
            if ((double)strength < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_0.get()) {
                entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 0, true, true));
                continue;
            }
            if ((double)strength < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_1.get()) {
                entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 1, true, true));
                continue;
            }
            if ((double)strength < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_2.get()) {
                entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(moveSlowdown, 180, 1, true, true));
                continue;
            }
            if ((double)strength < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_3.get()) {
                entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(moveSlowdown, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(weakness, 180, 1, true, true));
                continue;
            }
            if ((double)strength < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_4.get()) {
                entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(moveSlowdown, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(weakness, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(poison, 180, 1, true, true));
                continue;
            }
            if ((double)strength < (Double)RadiationConfiguration.RADIATION_EFFECT_LEVEL_5.get()) {
                entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(moveSlowdown, 180, 2, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(weakness, 180, 3, true, true));
                entityLivingBase.addEffect(new MobEffectInstance(poison, 180, 2, true, true));
                continue;
            }
            entityLivingBase.addEffect(new MobEffectInstance(hunger, 180, 2, true, true));
            entityLivingBase.addEffect(new MobEffectInstance(moveSlowdown, 180, 2, true, true));
            entityLivingBase.addEffect(new MobEffectInstance(weakness, 180, 3, true, true));
            entityLivingBase.addEffect(new MobEffectInstance(poison, 180, 3, true, true));
            entityLivingBase.addEffect(new MobEffectInstance(wither, 180, 2, true, true));
        }
    }
}

