/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.util;

import com.google.common.collect.Sets;
import java.util.Set;
import mcjty.deepresonance.modules.radiation.RadiationModule;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.deepresonance.util.DeepResonanceTags;
import mcjty.lib.varia.TagTools;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RadiationShieldRegistry {
    private static Set<Block> leadBlocks = null;

    private static Set<Block> getLeadBlocks() {
        if (leadBlocks != null) {
            return leadBlocks;
        }
        leadBlocks = Sets.newHashSet();
        Iterable blocks = TagTools.getBlocksForTag(DeepResonanceTags.STORAGE_BLOCKS_LEAD);
        blocks.forEach(h -> leadBlocks.add((Block)h.value()));
        return leadBlocks;
    }

    public static double getBlocker(BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.OBSIDIAN) {
            return (Double)RadiationConfiguration.RADIATION_SHIELD_OBSIDIAN_FACTOR.get();
        }
        if (block == RadiationModule.DENSE_OBSIDIAN.block().get()) {
            return (Double)RadiationConfiguration.RADIATION_SHIELD_DENSE_OBSIDIAN_FACTOR.get();
        }
        if (block == RadiationModule.DENSE_GLASS.block().get()) {
            return (Double)RadiationConfiguration.RADIATION_SHIELD_DENSE_GLASS_FACTOR.get();
        }
        if (RadiationShieldRegistry.getLeadBlocks().contains(block)) {
            return (Double)RadiationConfiguration.RADIATION_SHIELD_LEAD_FACTOR.get();
        }
        return 1.0;
    }
}

