/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.blocks;

import mcjty.deepresonance.compat.DeepResonanceTOPDriver;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.deepresonance.modules.tank.data.TankData;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankBlock
extends BaseBlock {
    private static final HolderLookup.Provider BUILTIN_PROVIDER = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY).freeze();

    public TankBlock() {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.of().noOcclusion().strength(2.0f).sound(SoundType.GLASS)).topDriver((TOPDriver)DeepResonanceTOPDriver.DRIVER).tileEntitySupplier(TankTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"liquid", TankBlock::getLiquid)}));
    }

    private static String getLiquid(ItemStack itemStack) {
        TankData data = (TankData)itemStack.get(TankModule.ITEM_TANK_DATA);
        if (data == null || data.preservedLiquid().isEmpty()) {
            return "";
        }
        FluidStack fluidStack = data.preservedLiquid();
        String name = I18n.get((String)fluidStack.getTranslationKey(), (Object[])new Object[0]);
        return name + " (" + fluidStack.getAmount() + "mb)";
    }

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack ret = new ItemStack((ItemLike)this);
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof TankTileEntity) {
            TankTileEntity tank = (TankTileEntity)tile;
            BlockItem.setBlockEntityData((ItemStack)ret, (BlockEntityType)((BlockEntityType)TankModule.TYPE_TANK.get()), (CompoundTag)tank.saveWithoutMetadata(TankBlock.provider()));
        }
        return ret;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tile = worldIn.getBlockEntity(pos);
        if (tile instanceof TankTileEntity) {
            TankTileEntity tank = (TankTileEntity)tile;
            return tank.getComparatorValue();
        }
        return 0;
    }

    private static HolderLookup.Provider provider() {
        return BUILTIN_PROVIDER;
    }
}

