/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.blocks;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.data.DRTankHandler;
import mcjty.deepresonance.modules.tank.data.DRTankNetwork;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.modules.tank.data.TankData;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TankTileEntity
extends GenericTileEntity
implements IMultiblockConnector {
    private int blobId = -1;
    @Nonnull
    private LiquidCrystalData clientRenderFluid = LiquidCrystalData.EMPTY;
    private float renderHeight;
    private final DRTankHandler fluidHandler = this.createFluidHandler();
    @Cap(type=CapType.FLUIDS)
    private static final Function<TankTileEntity, DRTankHandler> FLUID_CAP = tile -> tile.fluidHandler;

    public TankTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TankModule.TYPE_TANK.get(), pos, state);
    }

    public void setClientData(float newHeight, LiquidCrystalData render) {
        boolean dirty = false;
        if (newHeight >= 0.0f && this.renderHeight != newHeight) {
            this.renderHeight = newHeight;
            dirty = true;
        }
        if (!Objects.equals(this.clientRenderFluid, render)) {
            this.clientRenderFluid = LiquidCrystalData.fromStack(render.getFluidStack());
            dirty = true;
        }
        if (dirty) {
            this.markDirtyClient();
        }
    }

    public int getComparatorValue() {
        DRTankHandler handler = this.createFluidHandler();
        float f = (float)handler.getFluidInTank(0).getAmount() / (float)handler.getTankCapacity(0);
        return (int)(f * 15.0f);
    }

    public float getClientRenderHeight() {
        return this.renderHeight;
    }

    @Nonnull
    public Fluid getClientRenderFluid() {
        return this.clientRenderFluid.getFluidStack().getFluid();
    }

    public DRTankHandler getFluidHandler() {
        return this.createFluidHandler();
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putInt("blobid", this.blobId);
        this.saveClientDataToNBT(tagCompound, provider);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.blobId = tagCompound.contains("blobid") ? tagCompound.getInt("blobid") : -1;
        this.loadClientDataFromNBT(tagCompound, provider);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.putFloat("renderC", this.renderHeight);
        if (!this.clientRenderFluid.isEmpty()) {
            CompoundTag tag = (CompoundTag)this.clientRenderFluid.getFluidStack().saveOptional(provider);
            tagCompound.put("fluidC", (Tag)tag);
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.renderHeight = tagCompound.getFloat("renderC");
        if (tagCompound.contains("fluidC")) {
            Tag fluidTag = tagCompound.get("fluidC");
            if (StringTag.TYPE.equals((Object)fluidTag.getType())) {
                Fluid fluid = Tools.getFluid((ResourceLocation)ResourceLocation.parse((String)fluidTag.getAsString()));
                this.clientRenderFluid = LiquidCrystalData.fromStack(new FluidStack(fluid, 1));
            } else {
                FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)fluidTag));
                this.clientRenderFluid = LiquidCrystalData.fromStack(fluidStack);
            }
        } else {
            this.clientRenderFluid = LiquidCrystalData.EMPTY;
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        TankBlob network = this.getBlob();
        if (network != null) {
            FluidStack preservedFluid;
            LiquidCrystalData data = network.getData();
            if (!data.isEmpty()) {
                preservedFluid = data.getFluidStack().copy();
                int amount = data.getAmount() / network.getTankBlocks();
                preservedFluid.setAmount(amount);
                data.setAmount(data.getAmount() - amount);
            } else {
                preservedFluid = FluidStack.EMPTY;
            }
            builder.set(TankModule.ITEM_TANK_DATA, (Object)new TankData(preservedFluid));
        }
    }

    public InteractionResult onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (FluidUtil.getFluidHandler((ItemStack)itemInHand).isPresent()) {
            if (!this.level.isClientSide) {
                FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)this.getLevel(), (BlockPos)result.getBlockPos(), (Direction)result.getDirection());
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.level.isClientSide) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            FluidStack fluid = this.createFluidHandler().getFluidInTank(0);
            if (fluid.isEmpty()) {
                player.sendSystemMessage((Component)ComponentFactory.literal((String)"Tank is empty").withStyle(ChatFormatting.YELLOW));
            } else {
                String amount = " (" + fluid.getAmount() + " mb)";
                player.sendSystemMessage((Component)ComponentFactory.literal((String)"Liquid: ").append((Component)ComponentFactory.translatable((String)fluid.getTranslationKey())).append((Component)ComponentFactory.literal((String)amount)).withStyle(ChatFormatting.AQUA));
                if (LiquidCrystalData.isLiquidCrystal(fluid.getFluid())) {
                    LiquidCrystalData d = LiquidCrystalData.fromStack(fluid);
                    player.sendSystemMessage((Component)ComponentFactory.literal((String)("Quality " + decimalFormat.format(d.getQuality() * 100.0) + "%")));
                    player.sendSystemMessage((Component)ComponentFactory.literal((String)("Efficiency " + decimalFormat.format(d.getEfficiency() * 100.0) + "%")));
                    player.sendSystemMessage((Component)ComponentFactory.literal((String)("Purity " + decimalFormat.format(d.getPurity() * 100.0) + "%")));
                    player.sendSystemMessage((Component)ComponentFactory.literal((String)("Strength " + decimalFormat.format(d.getStrength() * 100.0) + "%")));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.isClientSide()) {
            TankData data;
            this.addBlockToNetwork();
            TankBlob network = this.getBlob();
            if (network != null && (data = (TankData)stack.get(TankModule.ITEM_TANK_DATA)) != null && !data.preservedLiquid().isEmpty()) {
                this.getDriver().modify(this.getMultiblockId(), holder -> {
                    FluidStack fluidStack = data.preservedLiquid();
                    if (!fluidStack.isEmpty()) {
                        ((TankBlob)holder.getMb()).fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        this.updateHeightsForClient();
                    }
                });
            }
        }
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (!world.isClientSide()) {
            BlockState stateDown;
            BlockState stateUp;
            if (newstate.getBlock() != TankModule.TANK.block().get()) {
                this.removeBlockFromNetwork();
            }
            if ((stateUp = world.getBlockState(pos.above())).getBlock() == GeneratorModule.GENERATOR_PART.block().get()) {
                world.sendBlockUpdated(pos.above(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.getBlockState(pos.below())).getBlock() == GeneratorModule.GENERATOR_PART.block().get()) {
                world.sendBlockUpdated(pos.below(), stateDown, stateDown, 3);
            }
        }
    }

    public void addBlockToNetwork() {
        TankBlob newMb = new TankBlob().setTankBlocks(1);
        newMb.updateDistribution(Collections.singleton(this.worldPosition));
        MultiblockSupport.addBlock((Level)this.level, (BlockPos)this.getBlockPos(), DRTankNetwork.getNetwork(this.level).getDriver(), (IMultiblock)newMb);
        this.updateHeightsForClient();
    }

    public void removeBlockFromNetwork() {
        MultiblockSupport.removeBlock((Level)this.level, (BlockPos)this.getBlockPos(), DRTankNetwork.getNetwork(this.level).getDriver());
    }

    @Nonnull
    public LiquidCrystalData getClientLiquidData() {
        return this.clientRenderFluid;
    }

    private void updateHeightsForClient() {
        int id = this.getMultiblockId();
        if (id != -1) {
            TankBlob blob = this.getBlob();
            LiquidCrystalData data = blob.getData();
            FluidStack fluidStack = data.getFluidStack();
            int amount = fluidStack.getAmount();
            int capacityPerTank = blob.getCapacityPerTank();
            DRTankNetwork.foreach(this.level, id, blockPos -> {
                BlockEntity be = this.level.getBlockEntity(blockPos);
                if (be instanceof TankTileEntity) {
                    float height;
                    int countBelow = blob.getBlocksBelowY(blockPos.getY());
                    int countAtY = blob.getBlocksAtY(blockPos.getY());
                    if (amount <= countBelow * capacityPerTank) {
                        height = 0.0f;
                    } else if (amount > (countBelow + countAtY) * capacityPerTank) {
                        height = 1.0f;
                    } else {
                        height = amount - countBelow * capacityPerTank;
                        height /= (float)(countAtY * capacityPerTank);
                    }
                    ((TankTileEntity)be).setClientData(height, data);
                }
            }, this.worldPosition);
        }
    }

    public ResourceLocation getId() {
        return DRTankNetwork.TANK_NETWORK_ID;
    }

    public int getMultiblockId() {
        return this.blobId;
    }

    public void setMultiblockId(int newId) {
        if (this.blobId != newId) {
            this.blobId = newId;
            this.setChanged();
        }
    }

    public TankBlob getBlob() {
        if (this.blobId == -1) {
            return null;
        }
        DRTankNetwork network = DRTankNetwork.getNetwork(this.level);
        return network.getOrCreateBlob(this.blobId);
    }

    private MultiblockDriver<TankBlob> getDriver() {
        return DRTankNetwork.getNetwork(this.level).getDriver();
    }

    public DRTankHandler getInternalFluidHandler() {
        return this.fluidHandler;
    }

    @Nonnull
    private DRTankHandler createFluidHandler() {
        return new DRTankHandler(this){

            @Override
            public void onUpdate() {
                TankTileEntity.this.updateHeightsForClient();
                TankTileEntity.this.setChanged();
                DRTankNetwork.getNetwork(TankTileEntity.this.level).save();
            }
        };
    }
}

