/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class TankTESR
implements BlockEntityRenderer<TankTileEntity> {
    public static final ResourceLocation TANK_BOTTOM = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/tank_bottom");
    public static final ResourceLocation TANK_TOP = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/tank_top");
    public static final ResourceLocation TANK_SIDE = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"block/tank_side");

    public TankTESR(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TankModule.TYPE_TANK.get()), TankTESR::new);
    }

    public void render(@Nonnull TankTileEntity tileTank, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TankTESR.renderInternal(tileTank, matrixStackIn, bufferIn, combinedLightIn);
    }

    public static void renderInternal(TankTileEntity tileTank, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        BlockPos pos = tileTank.getBlockPos();
        Fluid fluidToRender = tileTank.getClientRenderFluid();
        Set dirs = Arrays.stream(OrientationTools.DIRECTION_VALUES).filter(dir -> {
            if (dir == Direction.DOWN && (double)tileTank.getClientRenderHeight() > 1.0E-4 && fluidToRender != Fluids.EMPTY && ItemBlockRenderTypes.getRenderLayer((FluidState)fluidToRender.defaultFluidState()) == RenderType.solid()) {
                return false;
            }
            BlockEntity tile = tileTank.getLevel().getBlockEntity(pos.relative(dir));
            return !(tile instanceof TankTileEntity) || ((TankTileEntity)tile).getClientRenderFluid() != fluidToRender;
        }).collect(Collectors.toCollection(() -> EnumSet.noneOf(Direction.class)));
        float scale = tileTank.getClientRenderHeight();
        if (fluidToRender != Fluids.EMPTY) {
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidToRender);
            int color = attributes.getTintColor(fluidToRender.defaultFluidState(), (BlockAndTintGetter)tileTank.getLevel(), tileTank.getBlockPos());
            int luminosity = fluidToRender.getFluidType().getLightLevel();
            int packed = LightTexture.pack((int)Math.max(luminosity, combinedLightIn), (int)0);
            TankTESR.render(matrixStackIn, bufferIn, fluidToRender, dirs, combinedLightIn, packed, scale, color);
        }
    }

    private static void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, Fluid renderFluid, Set<Direction> dirs, int combinedLightIn, int liquidBrightness, float scale, int color) {
        matrixStackIn.pushPose();
        TankTESR.renderModel(matrixStackIn, bufferIn.getBuffer(RenderType.translucent()), dirs, combinedLightIn);
        if (renderFluid != null) {
            for (RenderType renderType : RenderType.chunkBufferLayers()) {
                if (ItemBlockRenderTypes.getRenderLayer((FluidState)renderFluid.defaultFluidState()) != renderType) continue;
                TankTESR.renderFluid(scale, color, bufferIn.getBuffer(renderType), renderFluid, dirs, liquidBrightness, matrixStackIn);
            }
        }
        matrixStackIn.popPose();
    }

    private static void renderModel(PoseStack matrixStack, VertexConsumer vertexBuilder, Set<Direction> dirs, int brightness) {
        if (dirs.contains(Direction.UP)) {
            TextureAtlasSprite tank_top = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(TANK_TOP);
            RenderHelper.drawQuad((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)tank_top, (Direction)Direction.UP, (boolean)true, (float)0.1f, (RenderSettings)RenderSettings.builder().brightness(brightness).build());
        }
        if (dirs.contains(Direction.DOWN)) {
            TextureAtlasSprite tank_bottom = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(TANK_BOTTOM);
            RenderHelper.drawQuad((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)tank_bottom, (Direction)Direction.DOWN, (boolean)true, (float)0.1f, (RenderSettings)RenderSettings.builder().brightness(brightness).build());
        }
        TextureAtlasSprite tank_side = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(TANK_SIDE);
        for (Direction dir : OrientationTools.HORIZONTAL_DIRECTION_VALUES) {
            RenderHelper.drawQuad((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)tank_side, (Direction)dir, (boolean)true, (float)0.1f, (RenderSettings)RenderSettings.builder().brightness(brightness).build());
        }
    }

    private static void renderFluid(float scale, int color, VertexConsumer vertexBuilder, Fluid fluidToRender, Set<Direction> dirs, int brightness, PoseStack matrixStack) {
        if (scale > 0.0f) {
            float offset = 0.015f;
            ResourceLocation stillTexture = IClientFluidTypeExtensions.of((Fluid)fluidToRender).getStillTexture();
            TextureAtlasSprite fluid = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stillTexture);
            RenderSettings settings = RenderSettings.builder().color(color).brightness(brightness).build();
            RenderHelper.drawBoxUnit((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)fluid, (boolean)false, (boolean)true, (boolean)dirs.contains(Direction.NORTH), (boolean)dirs.contains(Direction.SOUTH), (boolean)dirs.contains(Direction.WEST), (boolean)dirs.contains(Direction.EAST), (float)offset, (float)(1.0f - offset), (float)offset, (float)(scale - offset), (float)offset, (float)(1.0f - offset), (RenderSettings)settings);
        }
    }
}

