/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.worldgen.world;

import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.worldgen.util.WorldGenConfiguration;
import mcjty.deepresonance.modules.worldgen.world.ResonantCrystalFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ResonantCrystalFeature
extends Feature<ResonantCrystalFeatureConfig> {
    public static final ResourceLocation FEATURE_CRYSTAL_ID = ResourceLocation.fromNamespaceAndPath((String)"deepresonance", (String)"resonant_crystal");

    public ResonantCrystalFeature(Codec<ResonantCrystalFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ResonantCrystalFeatureConfig> context) {
        if (context.random().nextDouble() < (Double)WorldGenConfiguration.CRYSTAL_SPAWN_CHANCE.get()) {
            return this.trySpawnCrystal(context.level(), context.chunkGenerator(), new ChunkPos(context.origin()), context.random(), (ResonantCrystalFeatureConfig)context.config());
        }
        return false;
    }

    private boolean trySpawnCrystal(@Nonnull WorldGenLevel world, @Nonnull ChunkGenerator generator, ChunkPos chunkPos, RandomSource random, ResonantCrystalFeatureConfig config) {
        for (int i = 0; i < (Integer)WorldGenConfiguration.CRYSTAL_SPAWN_TRIES.get(); ++i) {
            BlockPos pos = new BlockPos(chunkPos.getMinBlockX() + random.nextInt(16), 0, chunkPos.getMinBlockZ() + random.nextInt(16));
            int y = world.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, pos.getX(), pos.getZ());
            pos = new BlockPos(pos.getX(), y - 1, pos.getZ());
            BlockPos.MutableBlockPos poz = pos.mutable();
            while (poz.getY() > world.getMinBuildHeight() && !world.getBlockState((BlockPos)poz).isAir()) {
                poz.move(Direction.DOWN);
            }
            while (poz.getY() > world.getMinBuildHeight() && world.getBlockState((BlockPos)poz).isAir()) {
                poz.move(Direction.DOWN);
            }
            if (!world.getBlockState((BlockPos)poz).isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)poz) || !world.getBlockState(pos = poz.above()).isAir()) continue;
            if (((Boolean)WorldGenConfiguration.VERBOSE.get()).booleanValue()) {
                DeepResonance.setup.getLogger().info("Spawned crystal at: " + String.valueOf(pos));
            }
            ResonantCrystalFeature.spawnRandomCrystal(world, random, pos, config.strength, config.power, config.efficiency, config.purity);
            return true;
        }
        return false;
    }

    public static void spawnRandomCrystal(WorldGenLevel world, RandomSource random, BlockPos pos, float str, float pow, float eff, float pur) {
        world.setBlock(pos, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_NATURAL.block().get())).defaultBlockState(), 3);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity tile = (ResonatingCrystalTileEntity)te;
            tile.setStrength(Math.min(100.0f, random.nextFloat() * str * 3.0f + 0.01f));
            tile.setPower(Math.min(100.0f, random.nextFloat() * pow * 60.0f + 0.2f));
            tile.setEfficiency(Math.min(100.0f, random.nextFloat() * eff * 3.0f + 0.1f));
            tile.setPurity(Math.min(100.0f, random.nextFloat() * pur * 10.0f + 5.0f));
        }
    }
}

